<?php
// Include database connection
//require_once 'config.php';
//Connect to Database
include("database.php");
include("session.php");

// Initialize variables
$search_results = [];
$search_type = "";
$search_value = "";
$error_message = "";

// Process search form submission
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $search_type = $_POST['search_type'] ?? '';
    $search_value = trim($_POST['search_value'] ?? '');
    
    if (!empty($search_value)) {
        // Sanitize input
        $search_value = $con->real_escape_string($search_value);
        
        switch ($search_type) {
            case 'policy_number':
                $search_results = searchByPolicyNumber($search_value, $con);
                break;
            case 'mobile_money_number':
                $search_results = searchByMobileMoneyNumber($search_value, $con);
                break;
            case 'full_name':
                $search_results = searchByFullName($search_value, $con);
                break;
            default:
                $error_message = "Invalid search type selected.";
        }
    } else {
        $error_message = "Please enter a search value.";
    }
}

// Search Functions
function searchByPolicyNumber($policy_number, $con) {
    $results = [];
    
    // Search in policy_details_view
    $sql = "SELECT * FROM policy_details_view WHERE policy_number LIKE '%$policy_number%'";
    $result = $con->query($sql);
    if ($result->num_rows > 0) {
        while($row = $result->fetch_assoc()) {
            $row['search_type'] = 'Policy Holder';
            $row['record_type'] = 'Primary Policyholder';
            $results[] = $row;
        }
    }
    
    // Search in secondary_view
    $sql = "SELECT *, 'Secondary Insured' as record_type FROM secondary_view 
            WHERE policy_number LIKE '%$policy_number%'";
    $result = $con->query($sql);
    if ($result->num_rows > 0) {
        while($row = $result->fetch_assoc()) {
            $row['search_type'] = 'Secondary Insured';
            $results[] = $row;
        }
    }
    
    // Search in beneficiary_view
    $sql = "SELECT *, 'Beneficiary' as record_type FROM beneficiary_view 
            WHERE policy_number LIKE '%$policy_number%'";
    $result = $con->query($sql);
    if ($result->num_rows > 0) {
        while($row = $result->fetch_assoc()) {
            $row['search_type'] = 'Beneficiary';
            $results[] = $row;
        }
    }
    
    return $results;
}

function searchByMobileMoneyNumber($phone, $con) {
    $results = [];
    $phone_pattern = "%" . preg_replace('/[^0-9]/', '', $phone) . "%";
    
    // Search in policy_details_view
    $sql = "SELECT * FROM policy_details_view 
            WHERE REPLACE(mobile_money_number, '.', '') LIKE '$phone_pattern' 
               OR REPLACE(mobile_money_number, 'E+', '') LIKE '$phone_pattern'";
    $result = $con->query($sql);
    if ($result->num_rows > 0) {
        while($row = $result->fetch_assoc()) {
            $row['search_type'] = 'Policy Holder';
            $row['record_type'] = 'Primary Policyholder';
            $results[] = $row;
        }
    }
    
    // Search in beneficiary_view
    $sql = "SELECT *, 'Beneficiary' as record_type FROM beneficiary_view 
            WHERE REPLACE(mobile_money_number, '.', '') LIKE '$phone_pattern' 
               OR REPLACE(mobile_money_number, 'E+', '') LIKE '$phone_pattern'";
    $result = $con->query($sql);
    if ($result->num_rows > 0) {
        while($row = $result->fetch_assoc()) {
            $row['search_type'] = 'Beneficiary';
            $results[] = $row;
        }
    }
    
    return $results;
}

function searchByFullName($name, $con) {
    $results = [];
    $name_pattern = "%$name%";
    
    // Search in all three tables
    $queries = [
        "SELECT *, 'Primary Policyholder' as record_type FROM policy_details_view 
         WHERE full_name LIKE '$name_pattern'" => 'Policy Holder',
        "SELECT *, 'Secondary Insured' as record_type FROM secondary_view 
         WHERE full_name LIKE '$name_pattern'" => 'Secondary Insured',
        "SELECT *, 'Beneficiary' as record_type FROM beneficiary_view 
         WHERE full_name LIKE '$name_pattern'" => 'Beneficiary'
    ];
    
    foreach ($queries as $sql => $search_type) {
        $result = $con->query($sql);
        if ($result->num_rows > 0) {
            while($row = $result->fetch_assoc()) {
                $row['search_type'] = $search_type;
                $results[] = $row;
            }
        }
    }
    
    return $results;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Policy Search System</title>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">

    <?php include 'main_menu_app.php'; ?>
    <style>
        body {
    background-image: url('images/ayo_banner4.png'); /* Replace with your actual image path */
    background-size: cover;
  background-position: center;
    background-repeat: no-repeat;
    background-attachment: fixed;
    opacity: 0.9; /* Adjust transparency (0.1 to 1) */
}

body::before {
    content: "";
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-image: url('images/ayo_banner4.png');
    background-size: cover;
    background-position: center;
    background-repeat: no-repeat;
    background-attachment: fixed;
    opacity: 0.5; /* Adjust transparency */
    z-index: -1;
}

.blue-text {
    color: blue;
}
</style>
    <style>
        :root {
            --primary-color: #6ec1e4;
            --primary-dark: #6ec1e4;
            --secondary-color: #ff4081;
            --light-bg: #f5f5f5;
            --card-shadow: 0 4px 20px 0 rgba(0,0,0,.14), 0 7px 10px -5px rgba(156,39,176,.4);
        }
        
        body {
            background-color: #f5f5f5;
            font-family: 'Roboto', sans-serif;
        }
        
        .card-header-primary {
            background: linear-gradient(60deg, var(--primary-color), var(--primary-dark));
            color: white;
        }
        
        .search-btn {
            background: linear-gradient(60deg, var(--primary-color), var(--primary-dark));
            color: white;
            border: none;
            padding: 10px 30px;
            border-radius: 30px;
            transition: all 0.3s ease;
        }
        
        .search-btn:hover {
            background: linear-gradient(60deg, var(--primary-dark), var(--primary-color));
            transform: translateY(-2px);
            box-shadow: 0 4px 10px rgba(0,0,0,0.2);
        }
        
        .search-card {
            box-shadow: var(--card-shadow);
            border-radius: 12px;
            border: none;
            margin-bottom: 30px;
        }
        
        .results-card {
            box-shadow: 0 2px 10px rgba(0,0,0,0.08);
            border-radius: 12px;
            border: none;
        }
        
        .badge-primary {
            background-color: var(--primary-color);
        }
        
        .badge-secondary {
            background-color: var(--secondary-color);
        }
        
        .badge-success {
            background-color: #4caf50;
        }
        
        .table th {
            border-top: none;
            font-weight: 600;
            color: #555;
        }
        
        .table-hover tbody tr:hover {
            background-color: rgba(156, 39, 176, 0.05);
        }
        
        .search-type-badge {
            font-size: 0.8em;
            padding: 5px 10px;
            border-radius: 20px;
        }
        
        .stats-card {
            background: white;
            border-radius: 10px;
            padding: 15px;
            margin-bottom: 20px;
            box-shadow: 0 2px 5px rgba(0,0,0,0.05);
        }
        
        .stats-icon {
            font-size: 2.5em;
            color: var(--primary-color);
            margin-bottom: 10px;
        }
        
        .stats-number {
            font-size: 1.8em;
            font-weight: bold;
            color: var(--primary-dark);
        }
        
        .stats-label {
            color: #666;
            font-size: 0.9em;
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        
        .form-control:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 0 0.2rem rgba(156, 39, 176, 0.25);
        }
        
        .select-wrapper {
            position: relative;
        }
        
        .select-wrapper:after {
            content: '\f078';
            font-family: 'Font Awesome 5 Free';
            font-weight: 900;
            position: absolute;
            right: 15px;
            top: 50%;
            transform: translateY(-50%);
            color: var(--primary-color);
            pointer-events: none;
        }
        
        .select-wrapper select {
            appearance: none;
            padding-right: 40px;
        }
        
        .no-results {
            text-align: center;
            padding: 40px;
            color: #666;
        }
        
        .no-results i {
            font-size: 3em;
            margin-bottom: 20px;
            color: #ddd;
        }
        
        .detail-item {
            margin-bottom: 10px;
            padding-bottom: 10px;
            border-bottom: 1px solid #eee;
        }
        
        .detail-item:last-child {
            border-bottom: none;
        }
    </style>
</head>
<body>
    <div class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12">
                    <div class="card search-card">
                        <div class="card-header card-header-primary" style="background: #6ec1e4; color: white; text-align: center; padding: 15px;">
                            <h4 class="card-title">
                                <i class="fas fa-search"></i> Policy Search System
                            </h4>
                            <p class="card-category">Search across policyholders, secondary insured, and beneficiaries</p>
                        </div>
                        
                        <div class="card-body">
                            <!-- Search Form -->
                            <form method="POST" action="">
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group mb-3">
                                            <label for="search_type" class="form-label">Search By:</label>
                                            <div class="select-wrapper">
                                                <select class="form-control" id="search_type" name="search_type" required>
                                                    <option value="">Select Search Type</option>
                                                    <option value="policy_number" <?= $search_type == 'policy_number' ? 'selected' : '' ?>>Policy Number</option>
                                                    <option value="mobile_money_number" <?= $search_type == 'mobile_money_number' ? 'selected' : '' ?>>Mobile Money Number</option>
                                                    <option value="full_name" <?= $search_type == 'full_name' ? 'selected' : '' ?>>Full Name</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-6">
                                        <div class="form-group mb-3">
                                            <label for="search_value" class="form-label">Search Value:</label>
                                            <input type="text" 
                                                   class="form-control" 
                                                   id="search_value" 
                                                   name="search_value" 
                                                   placeholder="Enter search term..." 
                                                   value="<?= htmlspecialchars($search_value) ?>"
                                                   required>
                                            <small class="form-text text-muted">
                                                For mobile money numbers, you can enter with or without country code
                                            </small>
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-2">
                                        <div class="form-group mb-3 d-flex align-items-end">
                                            <button type="submit" class="btn search-btn w-100">
                                                <i class="fas fa-search me-2"></i> Search
                                            </button>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="row mt-2">
                                    <div class="col-md-12">
                                        <div class="alert alert-info p-2">
                                            <i class="fas fa-info-circle me-1"></i> 
                                            <small>Search across Policy Holders, Secondary Insured, and Beneficiaries</small>
                                        </div>
                                    </div>
                                </div>
                            </form>
                            
                            <?php if (!empty($error_message)): ?>
                                <div class="alert alert-danger mt-3">
                                    <i class="fas fa-exclamation-triangle me-2"></i>
                                    <?= htmlspecialchars($error_message) ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    
                    <!-- Search Results -->
                    <?php if ($_SERVER['REQUEST_METHOD'] == 'POST' && empty($error_message)): ?>
                        <div class="card results-card">
                            <div class="card-header" style="background-color: #f8f9fa; border-bottom: 1px solid #eee;">
                                <div class="d-flex justify-content-between align-items-center">
                                    <h5 class="mb-0">
                                        <i class="fas fa-list-alt me-2"></i>
                                        Search Results
                                    </h5>
                                    <span class="badge bg-primary"><?= count($search_results) ?> records found</span>
                                </div>
                            </div>
                            
                            <div class="card-body">
                                <?php if (count($search_results) > 0): ?>
                                    <!-- Statistics Row - Removed Unique Policies -->
                                    <div class="row mb-4">
                                        <div class="col-md-4">
                                            <div class="stats-card text-center">
                                                <div class="stats-icon">
                                                    <i class="fas fa-user-tie"></i>
                                                </div>
                                                <div class="stats-number">
                                                    <?= count(array_filter($search_results, function($item) { 
                                                        return $item['record_type'] == 'Primary Policyholder'; 
                                                    })) ?>
                                                </div>
                                                <div class="stats-label">Policyholders</div>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="stats-card text-center">
                                                <div class="stats-icon">
                                                    <i class="fas fa-users"></i>
                                                </div>
                                                <div class="stats-number">
                                                    <?= count(array_filter($search_results, function($item) { 
                                                        return $item['record_type'] == 'Secondary Insured'; 
                                                    })) ?>
                                                </div>
                                                <div class="stats-label">Secondary Insured</div>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="stats-card text-center">
                                                <div class="stats-icon">
                                                    <i class="fas fa-user-friends"></i>
                                                </div>
                                                <div class="stats-number">
                                                    <?= count(array_filter($search_results, function($item) { 
                                                        return $item['record_type'] == 'Beneficiary'; 
                                                    })) ?>
                                                </div>
                                                <div class="stats-label">Beneficiaries</div>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <!-- Results Table -->
                                    <div class="table-responsive">
                                        <table class="table table-hover">
                                            <thead>
                                                <tr>
                                                    <th>Type</th>
                                                    <th>Policy Number</th>
                                                    <th>Full Name</th>
                                                    <th>Contact/Details</th>                                                    
                                                    <th>Actions</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php foreach ($search_results as $record): ?>
                                                <tr>
                                                    <td>
                                                        <?php 
                                                        $badge_class = '';
                                                        $icon = '';
                                                        if ($record['record_type'] == 'Primary Policyholder') {
                                                            $badge_class = 'bg-primary';
                                                            $icon = 'fa-user-tie';
                                                        } elseif ($record['record_type'] == 'Secondary Insured') {
                                                            $badge_class = 'bg-secondary';
                                                            $icon = 'fa-users';
                                                        } else {
                                                            $badge_class = 'bg-success';
                                                            $icon = 'fa-user-friends';
                                                        }
                                                        ?>
                                                        <span class="badge search-type-badge <?= $badge_class ?>">
                                                            <i class="fas <?= $icon ?> me-1"></i>
                                                            <?= $record['record_type'] ?>
                                                        </span>
                                                    </td>
                                                    <td>
                                                        <strong class="text-primary"><?= htmlspecialchars($record['policy_number'] ?? 'N/A') ?></strong>
                                                    </td>
                                                    <td>
                                                        <strong><?= htmlspecialchars($record['full_name'] ?? 'N/A') ?></strong>
                                                        <?php if (isset($record['relationship'])): ?>
                                                            <br><small class="text-muted"><?= $record['relationship'] ?></small>
                                                        <?php endif; ?>
                                                        <?php if (isset($record['gender'])): ?>
                                                            <br><small class="text-muted"><?= $record['gender'] ?></small>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td>
                                                        <?php if ($record['record_type'] == 'Primary Policyholder'): ?>
                                                            <small>
                                                                <i class="fas fa-phone me-1"></i>
                                                                <?= htmlspecialchars(formatPhoneNumber($record['mobile_money_number'] ?? '')) ?><br>
                                                                <?php if (isset($record['momo_network'])): ?>
                                                                    <i class="fas fa-wifi me-1"></i> <?= $record['momo_network'] ?><br>
                                                                <?php endif; ?>
                                                                <i class="fas fa-birthday-cake me-1"></i>
                                                                <?= htmlspecialchars($record['date_of_birth'] ?? 'N/A') ?>
                                                            </small>
                                                        <?php elseif ($record['record_type'] == 'Secondary Insured'): ?>
                                                            <small>
                                                                <i class="fas fa-birthday-cake me-1"></i>
                                                                <?= htmlspecialchars($record['date_of_birth'] ?? 'N/A') ?><br>
                                                                <i class="fas fa-user-clock me-1"></i>
                                                                Age: <?= htmlspecialchars($record['age_at_entry'] ?? 'N/A') ?>
                                                            </small>
                                                        <?php else: ?>
                                                            <small>
                                                                <?php if (isset($record['mobile_money_number'])): ?>
                                                                    <i class="fas fa-phone me-1"></i>
                                                                    <?= htmlspecialchars(formatPhoneNumber($record['mobile_money_number'])) ?><br>
                                                                <?php endif; ?>
                                                                <?php if (isset($record['relationship'])): ?>
                                                                    <i class="fas fa-handshake me-1"></i>
                                                                    <?= $record['relationship'] ?>
                                                                <?php endif; ?>
                                                            </small>
                                                        <?php endif; ?>
                                                    </td>
                                                    
                                                    <td>
                                                        <button class="btn btn-sm btn-outline-primary" 
                                                                onclick="viewDetails(<?= htmlspecialchars(json_encode($record)) ?>)">
                                                            <i class="fas fa-eye me-1"></i> View
                                                        </button>
                                                    </td>
                                                </tr>
                                                <?php endforeach; ?>
                                            </tbody>
                                        </table>
                                    </div>
                                <?php else: ?>
                                    <div class="no-results">
                                        <i class="fas fa-search-minus"></i>
                                        <h4>No Results Found</h4>
                                        <p>No records match your search criteria. Try a different search term.</p>
                                        <div class="mt-3">
                                            <small class="text-muted">
                                                <i class="fas fa-lightbulb me-1"></i>
                                                Try searching by:
                                            </small>
                                            <div class="mt-2">
                                                <span class="badge bg-light text-dark me-2">Policy Number</span>
                                                <span class="badge bg-light text-dark me-2">Full Name</span>
                                                <span class="badge bg-light text-dark">Mobile Money Number</span>
                                            </div>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Modal for Detailed View -->
    <div class="modal fade" id="detailsModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header card-header-primary text-white">
                    <h5 class="modal-title">
                        <i class="fas fa-file-alt me-2"></i>Record Details
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body" id="modalBody">
                    <!-- Details will be loaded here -->
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Bootstrap JS Bundle with Popper -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
    function viewDetails(record) {
        let modalBody = document.getElementById('modalBody');
        let content = '';
        
        if (record.record_type === 'Primary Policyholder') {
            content = `
                <div class="row">
                    <div class="col-md-12 mb-3">
                        <div class="alert alert-primary">
                            <h6 class="mb-0"><i class="fas fa-user-tie me-2"></i>Primary Policyholder Details</h6>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="detail-item">
                            <strong><i class="fas fa-user me-2"></i>Full Name:</strong><br>
                            <span class="ms-4">${record.full_name || 'N/A'}</span>
                        </div>
                        <div class="detail-item">
                            <strong><i class="fas fa-birthday-cake me-2"></i>Date of Birth:</strong><br>
                            <span class="ms-4">${record.date_of_birth || 'N/A'}</span>
                        </div>
                        <div class="detail-item">
                            <strong><i class="fas fa-venus-mars me-2"></i>Gender:</strong><br>
                            <span class="ms-4">${record.gender || 'N/A'}</span>
                        </div>
                        <div class="detail-item">
                            <strong><i class="fas fa-phone me-2"></i>Mobile Money:</strong><br>
                            <span class="ms-4">${record.mobile_money_number || 'N/A'}</span>
                        </div>
                        <div class="detail-item">
                            <strong><i class="fas fa-wifi me-2"></i>Network:</strong><br>
                            <span class="ms-4">${record.momo_network || 'N/A'}</span>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="detail-item">
                            <strong><i class="fas fa-file-contract me-2"></i>Policy Number:</strong><br>
                            <span class="ms-4">${record.policy_number || 'N/A'}</span>
                        </div>
                        <div class="detail-item">
                            <strong><i class="fas fa-cube me-2"></i>Product Name:</strong><br>
                            <span class="ms-4">${record.product_name || 'N/A'}</span>
                        </div>
                        <div class="detail-item">
                            <strong><i class="fas fa-money-bill-wave me-2"></i>Premium:</strong><br>
                            <span class="ms-4">GHS ${record.set_premium || 'N/A'}</span>
                        </div>
                        <div class="detail-item">
                            <strong><i class="fas fa-calendar-check me-2"></i>Inception Date:</strong><br>
                            <span class="ms-4">${record.inception_date || 'N/A'}</span>
                        </div>
                        <div class="detail-item">
                            <strong><i class="fas fa-sign-in-alt me-2"></i>Channel:</strong><br>
                            <span class="ms-4">${record.onboarding_channel || 'N/A'}</span>
                        </div>
                        
                    </div>
                </div>
            `;
        } else if (record.record_type === 'Secondary Insured') {
            content = `
                <div class="row">
                    <div class="col-md-12 mb-3">
                        <div class="alert alert-secondary">
                            <h6 class="mb-0"><i class="fas fa-users me-2"></i>Secondary Insured Details</h6>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="detail-item">
                            <strong><i class="fas fa-user me-2"></i>Full Name:</strong><br>
                            <span class="ms-4">${record.full_name || 'N/A'}</span>
                        </div>
                        <div class="detail-item">
                            <strong><i class="fas fa-handshake me-2"></i>Relationship:</strong><br>
                            <span class="ms-4">${record.relationship || 'N/A'}</span>
                        </div>
                        <div class="detail-item">
                            <strong><i class="fas fa-birthday-cake me-2"></i>Date of Birth:</strong><br>
                            <span class="ms-4">${record.date_of_birth || 'N/A'}</span>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="detail-item">
                            <strong><i class="fas fa-file-contract me-2"></i>Policy Number:</strong><br>
                            <span class="ms-4">${record.policy_number || 'N/A'}</span>
                        </div>
                        <div class="detail-item">
                            <strong><i class="fas fa-user-clock me-2"></i>Age at Entry:</strong><br>
                            <span class="ms-4">${record.age_at_entry || 'N/A'}</span>
                        </div>
                        
                    </div>
                </div>
            `;
        } else { // Beneficiary
            content = `
                <div class="row">
                    <div class="col-md-12 mb-3">
                        <div class="alert alert-success">
                            <h6 class="mb-0"><i class="fas fa-user-friends me-2"></i>Beneficiary Details</h6>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="detail-item">
                            <strong><i class="fas fa-user me-2"></i>Full Name:</strong><br>
                            <span class="ms-4">${record.full_name || 'N/A'}</span>
                        </div>
                        <div class="detail-item">
                            <strong><i class="fas fa-handshake me-2"></i>Relationship:</strong><br>
                            <span class="ms-4">${record.relationship || 'N/A'}</span>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="detail-item">
                            <strong><i class="fas fa-file-contract me-2"></i>Policy Number:</strong><br>
                            <span class="ms-4">${record.policy_number || 'N/A'}</span>
                        </div>
                        <div class="detail-item">
                            <strong><i class="fas fa-phone me-2"></i>Mobile Money:</strong><br>
                            <span class="ms-4">${record.mobile_money_number || 'N/A'}</span>
                        </div>
                    </div>
                </div>
            `;
        }
        
        modalBody.innerHTML = content;
        let modal = new bootstrap.Modal(document.getElementById('detailsModal'));
        modal.show();
    }
    
    // Auto-focus search field
    document.addEventListener('DOMContentLoaded', function() {
        document.getElementById('search_value').focus();
    });
    </script>
</body>
</html>
<?php
// Helper function to format phone numbers
function formatPhoneNumber($phone) {
    if (empty($phone)) return 'N/A';
    
    // Remove scientific notation if present
    if (strpos($phone, 'E+') !== false) {
        $phone = number_format(floatval($phone), 0, '', '');
    }
    
    // Remove any non-numeric characters
    $phone = preg_replace('/[^0-9]/', '', $phone);
    
    // Format based on length
    if (strlen($phone) == 12 && substr($phone, 0, 3) == '233') {
        return '+233 ' . substr($phone, 3, 3) . ' ' . substr($phone, 6, 3) . ' ' . substr($phone, 9, 3);
    } elseif (strlen($phone) == 10 && substr($phone, 0, 1) == '0') {
        return '+233 ' . substr($phone, 1, 3) . ' ' . substr($phone, 4, 3) . ' ' . substr($phone, 7, 3);
    } elseif (strlen($phone) == 9) {
        return '+233 ' . substr($phone, 0, 3) . ' ' . substr($phone, 3, 3) . ' ' . substr($phone, 6, 3);
    }
    
    return $phone;
}

// Close database connection
$con->close();
?>