<?php  
//Connect to Database
include("database.php");
//require_once('crypto_functions.php');
include("session.php");


$msg 			= 	htmlspecialchars(filter_var(mysqli_real_escape_string($con,$_REQUEST['msg']),FILTER_SANITIZE_STRING));


// Start session and validate it
session_start();
if (!isset($_SESSION['userindex'])) {
    die("Unauthorized access.");
}

// Use prepared statements to prevent SQL injection
//$msg = htmlspecialchars(filter_input(INPUT_POST, 'msg', FILTER_SANITIZE_STRING));
$name = htmlspecialchars(filter_input(INPUT_POST, 'name', FILTER_SANITIZE_STRING));
$userindex = $_SESSION['userindex'];



// Capturing date securely
$capturing_date = date("Y-m-d");

?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8" />
  <link rel="icon" type="image/png" href="../assets/img/favicon.png">
  <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />
  <title>Add New Branch Page</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
  <link href="../assets/css/material-dashboard.css?v=2.1.1" rel="stylesheet" />
  <link href="../assets/demo/demo.css" rel="stylesheet" />
</head>
<body>
<?php include 'main_menu.php'; ?>
<style>
        body {
    background-image: url('images/ayo_banner4.png'); /* Replace with your actual image path */
    background-size: cover;
  background-position: center;
    background-repeat: no-repeat;
    background-attachment: fixed;
    opacity: 0.9; /* Adjust transparency (0.1 to 1) */
}

body::before {
    content: "";
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-image: url('images/ayo_banner4.png');
    background-size: cover;
    background-position: center;
    background-repeat: no-repeat;
    background-attachment: fixed;
    opacity: 0.5; /* Adjust transparency */
    z-index: -1;
}


</style>
<script type="text/javascript">
window.onload = function(){ 
               
   if (form.msg.value == "") {
    return false ;
  }
      if(form.msg.value == "10$204?c") {
    alert("Submitted Successfully");
    form.msg.focus();
    return false ;
  } 
  

}
</script>

<script>
// Example client-side validation
function validateForm(form) {
    const requiredFields = ['branch_code', 'branch_name', 'branch_location', 'branch_contact', 'branch_companyindex'];
    for (let field of requiredFields) {
        if (form[field].value.trim() === "") {
            alert(`Please fill in ${field.replace('_', ' ')}`);
            form[field].focus();
            return false;
        }
    }
    return true;
}
</script>

<div class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-8">
                <div class="card">
                   <div class="card-header card-header-primary" style="background: #6ec1e4; color: white; text-align: center; padding: 15px;">
                         <h4 class="card-title" style="color:rgb(10, 44, 234); font-weight: bold; text-align: center;">Add New Branch</h4>
                        <p class="card-category">Please Complete This Form</p>
                    </div>
                    <div class="card-body">
                        <form id="form" name="form" method="post" action="branch_add_eng.php" onsubmit="return validateForm(this)">
                            <div class="row">                               
                                <div class="col-md-5">
                                    <div class="form-group">
                                        <label class="bmd-label-floating">Branch Name</label>
                                        <input type="text" class="form-control" name="branch_name" required>
                                    </div>
                                </div>
                                <div class="col-md-5">
                                    <div class="form-group">
                                        <label class="bmd-label-floating">Branch Location</label>
                                        <input type="text" class="form-control" name="branch_location" required>
                                        <input type="hidden" class="form-control" name="userindex" value ="<?php echo htmlspecialchars($userindex); ?>">
                                        <input type="hidden" class="form-control" name="msg" value ="<?php echo htmlspecialchars($msg); ?>">
                                      </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label class="bmd-label-floating">Branch Contacts</label>
                                        <input type="text" class="form-control" name="branch_contact" pattern="\d+" required>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label class="bmd-label-floating">Branch Registration Date</label>
                                        <input type="text" class="form-control" readonly name="capturing_date" value="<?php echo htmlspecialchars($capturing_date); ?>">
                                    </div>
                                </div>
                                
                                <div class="col-md-7">
                                    <div class="form-group">
                                        <label class="bmd-label-floating">Organization</label>
                                        <select name="branch_companyindex" class="form-control" required>
                                            <option value="">Select</option>
                                            <?php
                                            // Fetch organizations securely
                                            $stmt = $con->prepare("SELECT companyindex, company_name FROM company");
                                            $stmt->execute();
                                            $result = $stmt->get_result();
                                            while ($row = $result->fetch_assoc()) {
                                                echo "<option value='" . htmlspecialchars($row['companyindex']) . "'>" . htmlspecialchars($row['company_name']) . "</option>";
                                            }
                                            $stmt->close();
                                            ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <button type="submit" class="btn btn-primary pull-right"  style="background: #6ec1e4; color: white; text-align: center; padding: 15px;">Submit</button>
                            <div class="clearfix"></div>
                        </form>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card card-profile">
                    <div class="card-avatar">
                        <a href="#pablo">
                            <img class="img" src="images/branch_office.png" />
                        </a>
                    </div>
                    <div class="card-body">
                        <h6 class="card-category text-gray">Admin Name: <?php echo htmlspecialchars($name); ?></h6>
                        <h4 class="card-title">Summary</h4>
                        <p class="card-description">
                       <?php
$stmt = $con->prepare("SELECT COUNT(branchindex) AS count_active FROM branch");
$stmt->execute();
$stmt->bind_result($count_active);
$stmt->fetch();
echo 'Total Branches: ' . htmlspecialchars($count_active);
$stmt->close();
?>
                        </p>
                        <p class="card-description">
                           
                        </p>
                        <a href="branch_report.php?sr=016!b101" class="btn btn-primary btn-round" style="background: #6ec1e4; color: white; text-align: center; padding: 15px;">View Report</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
</body>
</html>
