<?php 
//Connect to Database
include("database.php");
require_once('crypto_functions.php');
include("session.php");

function sanitize_input($input) {
    return htmlspecialchars(filter_var($input, FILTER_SANITIZE_STRING, FILTER_FLAG_NO_ENCODE_QUOTES), ENT_QUOTES, 'UTF-8');
}

// Sanitize inputs
$msg = isset($_REQUEST['msg']) ? sanitize_input($_REQUEST['msg']) : '';
$name = isset($_REQUEST['name']) ? sanitize_input($_REQUEST['name']) : '';
$userindex = isset($_SESSION['userindex']) ? sanitize_input($_SESSION['userindex']) : '';
$idn = isset($_REQUEST['id']) ? sanitize_input($_REQUEST['id']) : '';

// Encrypt the data
$id = decrypt($idn);
$id = urlencode($id);

//echo $id;exit;


// Assuming $con is already a valid mysqli connection and $id is defined

if (!empty($id)) {
    // First query: get branch details
    $query = "SELECT branch_name, branch_location, branch_contact,branch_companyindex FROM branch WHERE branchindex = ?";
    $stmt = $con->prepare($query);

    if (!$stmt) {
        die("Prepare failed (branch): " . $con->error);
    }

    $stmt->bind_param("s", $id);
    $stmt->execute();
    $result_search = $stmt->get_result();

    if ($result_search->num_rows > 0) {
        $test_search = $result_search->fetch_assoc();
        $branch_name = trim($test_search['branch_name']);
        $branch_location = trim($test_search['branch_location']);
        $branch_contact = trim($test_search['branch_contact']);
         $branch_orgindex = trim($test_search['branch_companyindex']);
    } else {
        die("Error: Branch not found.");
    }

    $stmt->close();

    // Second query: get company details using branch_orgindex
    $query_org = "SELECT companyindex, company_name FROM company WHERE companyindex = ?";
    $stmt_org = $con->prepare($query_org);

    if (!$stmt_org) {
        die("Prepare failed (company): " . $con->error);
    }

    $stmt_org->bind_param("s", $branch_orgindex);
    $stmt_org->execute();
    $result_org = $stmt_org->get_result();

    if ($result_org->num_rows > 0) {
        $test_org = $result_org->fetch_assoc();
        $company_name = trim($test_org['company_name']);
        $companyindex = trim($test_org['companyindex']);
    } else {
        die("Error: Company not found.");
    }

    $stmt_org->close();

} else {
    die("Error: Invalid branch index.");
}
?>

//echo $branchindex;exit;

?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8" />
  <link rel="apple-touch-icon" sizes="76x76" href="../assets/img/apple-icon.png">
  <link rel="icon" type="image/png" href="../assets/img/favicon.png">
  <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />
  <title>
EDIT BRANCH PAGE
  </title>
  <meta content='width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0, shrink-to-fit=no' name='viewport' />
  <!--     Fonts and icons     -->
  <!-- CSS Files -->
  <link href="../assets/css/material-dashboard.css?v=2.1.1" rel="stylesheet" />
  <!-- CSS Just for demo purpose, don't include it in your project -->
  <link href="../assets/demo/demo.css" rel="stylesheet" />
</head>

<?php $capturing_date = date("d-m-Y"); ?>

<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8" />
  <link rel="icon" type="image/png" href="../assets/img/favicon.png">
  <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />
  <title>Edit Branch Page</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
  <link href="../assets/css/material-dashboard.css?v=2.1.1" rel="stylesheet" />
  <link href="../assets/demo/demo.css" rel="stylesheet" />
</head>
<body>
<?php include 'main_menu.php'; ?>
<style>
        body {
    background-image: url('images/ayo_banner4.png'); /* Replace with your actual image path */
    background-size: cover;
  background-position: center;
    background-repeat: no-repeat;
    background-attachment: fixed;
    opacity: 0.9; /* Adjust transparency (0.1 to 1) */
}

body::before {
    content: "";
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-image: url('images/ayo_banner4.png');
    background-size: cover;
    background-position: center;
    background-repeat: no-repeat;
    background-attachment: fixed;
    opacity: 0.5; /* Adjust transparency */
    z-index: -1;
}

.blue-text {
    color: blue;
}
</style>

<script>
// Example client-side validation
function validateForm(form) {
    const requiredFields = ['branch_name', 'branch_location', 'branch_contact', 'branch_status', 'companyindex'];
    for (let field of requiredFields) {
        if (form[field].value.trim() === "") {
            alert(`Please fill in ${field.replace('_', ' ')}`);
            form[field].focus();
            return false;
        }
    }
    return true;
}
</script>

<div class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header card-header-primary" style="background: #6ec1e4; color: white; text-align: center; padding: 15px;">
                      <h4 class="card-title" style="color:rgb(10, 44, 234); font-weight: bold; text-align: center;">Edit New Branch</h4>
                        <p class="card-category">Please Complete This Form</p>
                    </div>
                    <div class="card-body">
                        <form id="form" name="form" method="post" action="branch_edit_eng.php" onsubmit="return validateForm(this)">
                            <div class="row">                               
                                <div class="col-md-5">
                                    <div class="form-group">
                                        <label class="bmd-label-floating">Branch Name</label>
                                        <input type="text" class="form-control" name="branch_name" required value ="<?php echo htmlspecialchars($branch_name); ?>" >
                                    </div>
                                </div>
                                <div class="col-md-5">
                                    <div class="form-group">
                                        <label class="bmd-label-floating">Branch Location</label>
                                        <input type="text" class="form-control" name="branch_location" required value ="<?php echo htmlspecialchars($branch_location); ?>">
                                        <input type="hidden" class="form-control" name="userindex" value ="<?php echo htmlspecialchars($userindex); ?>">
                                        <input type="hidden" class="form-control" name="id" value ="<?php echo htmlspecialchars($id); ?>">
                                                                       
                                      </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label class="bmd-label-floating">Branch Contacts</label>
                                        <input type="text" class="form-control" name="branch_contact" pattern="\d+" required value ="<?php echo htmlspecialchars($branch_contact); ?>">
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label class="bmd-label-floating">Branch Registration Date</label>
                                        <input type="text" class="form-control" readonly name="capturing_date" value="<?php echo htmlspecialchars($capturing_date); ?>">
                                    </div>
                                </div>
                                
                                <div class="col-md-7">
                                    <div class="form-group">
                                        <label class="bmd-label-floating">Organization</label>
                                        <select name="companyindex" class="form-control" required>
                                            <option value="<?php  echo htmlspecialchars($companyindex); ?>"><?php  echo htmlspecialchars($company_name); ?></option>
                                            <?php
                                                                                        // Fetch organizations securely
                                            $stmt = $con->prepare("SELECT companyindex, company_name FROM company");
                                            $stmt->execute();
                                            $result = $stmt->get_result();
                                            while ($row = $result->fetch_assoc()) {
                                                echo "<option value='" . htmlspecialchars($row['companyindex']) . "'>" . htmlspecialchars($row['company_name']) . "</option>";
                                            }
                                            $stmt->close();
                                            ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <button type="submit" class="btn btn-primary pull-right" style="background: #6ec1e4; color: white; text-align: center; padding: 15px;">Update</button>
                            <div class="clearfix"></div>
                        </form>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card card-profile">
                    <div class="card-avatar">
                        <a href="#pablo">
                            <img class="img" src="images/branch_office.png" />
                        </a>
                    </div>
                    <div class="card-body">
                        <h6 class="card-category text-gray">Admin Name: <?php echo htmlspecialchars($name); ?></h6>
                        <h4 class="card-title">Summary</h4>
                        <p class="card-description">
                                    <?php
$stmt = $con->prepare("SELECT COUNT(branchindex) AS count_active FROM branch");
$stmt->execute();
$stmt->bind_result($count_active);
$stmt->fetch();
echo 'Total Branches: ' . htmlspecialchars($count_active);
$stmt->close();
?>
                        </p>
                        <p class="card-description">

                        </p>
                        <a href="branch_report.php?sr=016!b101" class="btn btn-primary btn-round" style="background: #6ec1e4; color: white; text-align: center; padding: 15px;">View Report</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
</body>
</html>
