<?php
//Connect to Database
include("database.php");
include("crypto_functions.php");
require_once 'sms_function.php';
session_start();



// Sanitize and validate input
$confirm_password = filter_var($_POST['confirm_password'], FILTER_SANITIZE_STRING);
$userindex = filter_var($_POST['userindex'], FILTER_SANITIZE_STRING);
$password = filter_var($_POST['password'], FILTER_SANITIZE_STRING);
$user_maxtime = filter_var($_POST['user_maxtime'], FILTER_SANITIZE_NUMBER_INT);


// Encrypt the data
$data = $userindex;
$encrypted_string = encrypt($data);
$encoded_string = urlencode($encrypted_string);

//echo $userindex.' '.$encrypted_string;exit;

//format date
$date_time = date("Y-m-d h:i:s");

//Check Password 
if ($password <> $confirm_password ) 
		{
    // Set variables
    $caption = 'Password Not The Same';
     $path = 'login_change_password_eng.php';    
            
    $logStmt = $con->prepare("INSERT INTO users_logs (userindex, caption, logs_date, path) VALUES (?, ?, ?, ?)");
    $logStmt->bind_param("ssss", $userindex, $caption, $date_time, $path);
    $logStmt->execute();     

header ("location:login_changepassword.php?id=$encoded_string&msg=1");exit;
		}

if (strlen($password) < 12) {
      // Set variables
      $caption = 'Atleast 12 characters lengt';
      $path = 'login_change_password_eng.php';    
             
     $logStmt = $con->prepare("INSERT INTO users_logs (userindex, caption, logs_date, path) VALUES (?, ?, ?, ?)");
     $logStmt->bind_param("ssss", $userindex, $caption, $date_time, $path);
     $logStmt->execute();   
   
header ("location:login_changepassword.php?id=$encoded_string&msg=2");exit;
}


if (!preg_match('/([a-z]{1,})/', $password)) {

  // Set variables
  $caption = 'Atleast One lowercase letter';
  $path = 'login_change_password_eng.php';    
         
 $logStmt = $con->prepare("INSERT INTO users_logs (userindex, caption, logs_date, path) VALUES (?, ?, ?, ?)");
 $logStmt->bind_param("ssss", $userindex, $caption, $date_time, $path);  
 $logStmt->execute(); 
    
header ("location:login_changepassword.php?id=$encoded_string&msg=3");exit;

}



if (!preg_match('/([A-Z]{1,})/', $password)) {

    // Set variables
    $caption = 'Atleast One Uppercase Letter';
    $path = 'login_change_password_eng.php';
    $data_inf='N/A';    
           
   $logStmt = $con->prepare("INSERT INTO users_logs (userindex, caption, logs_date, path ,data_inf) VALUES (?, ?, ?, ?, ?)");
   $logStmt->bind_param("sssss", $userindex, $caption, $date_time, $path ,$data_inf);
   $logStmt->execute();   
      
header ("location:login_changepassword.php?id=$encoded_string&msg=4");exit;
}


if (!preg_match('/([\d]{1,})/', $password)) {

      // Set variables
      $caption = 'Altelast One Digit';
      $path = 'login_change_password_eng.php';    
             
     $logStmt = $con->prepare("INSERT INTO users_logs (userindex, caption, logs_date, path) VALUES (?, ?, ?, ?)");
     $logStmt->bind_param("ssss", $userindex, $caption, $date_time, $path);
     $logStmt->execute();  
     
header ("location:login_changepassword.php?id=$encoded_string&msg=5");exit;
}



if (!preg_match('/[\'.,:;*?~`!@#$%^&+=)(<>{}]|\]|\[|\/|\\\|\"|\|/', $password)) {

      // Set variables
      $caption = 'Altelast One Character';
      $path = 'login_change_password_eng.php';    
             
     $logStmt = $con->prepare("INSERT INTO users_logs (userindex, caption, logs_date, path) VALUES (?, ?, ?, ?)");
     $logStmt->bind_param("ssss", $userindex, $caption, $date_time, $path);  
     $logStmt->execute();
  
header ("location:login_changepassword.php?id=$encoded_string&msg=6");exit;
}



// Hash password securely
$options = ['cost' => 11];
$hashedPassword = password_hash($password, PASSWORD_BCRYPT, $options);

// Calculate the new user end date
$currentdate = strtotime(date("Y-m-d") . " +$user_maxtime days");
$newuserenddate = date("Y-m-d", $currentdate);

// Update user password securely using a prepared statement
$updateStmt = $con->prepare("UPDATE users SET user_password=?, user_changepassword='0', user_enddate=? WHERE userindex=?");
$updateStmt->bind_param("sss", $hashedPassword, $newuserenddate, $userindex);
$updateStmt->execute();


      // Set variables
      $caption = 'Password Updated Successfully';
      $path = 'login_change_password_eng.php';    
             
     $logStmt = $con->prepare("INSERT INTO users_logs (userindex, caption, logs_date, path) VALUES (?, ?, ?, ?)");
     $logStmt->bind_param("ssss", $userindex, $caption, $date_time, $path);  

// remove all session variables
session_unset();

// destroy the session
session_destroy(); 

header("location:login.php?msg=9");exit;

?>