<?php
include 'login_main_menu.php';
// Start the session at the beginning of the page
session_start();


  // Remove all session variables
    session_unset();

    // Destroy the session
    session_destroy();


?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Automatic Countdown Timer</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
              body {
    background-image: url('images/ayo_banner4.png'); /* Replace with your actual image path */
    background-size: cover;
  background-position: center;
    background-repeat: no-repeat;
    background-attachment: fixed;
    opacity: 0.9; /* Adjust transparency (0.1 to 1) */
}

body::before {
    content: "";
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-image: url('images/ayo_banner4.png');
    background-size: cover;
    background-position: center;
    background-repeat: no-repeat;
    background-attachment: fixed;
    opacity: 0.5; /* Adjust transparency */
    z-index: -1;
}

        
        .container {
            max-width: 800px;
            width: 100%;
            background: rgba(255, 255, 255, 0.95);
            border-radius: 20px;
            box-shadow: 0 15px 40px rgba(0, 0, 0, 0.3);
            overflow: hidden;
        }
        
        .header {
            background: linear-gradient(to right, #1a2a6c, #3a5fc5);
            color: white;
            padding: 40px 30px;
            text-align: center;
            position: relative;
        }
        
        .header h1 {
            font-size: 2.8rem;
            margin-bottom: 10px;
            text-shadow: 0 2px 4px rgba(0,0,0,0.3);
        }
        
        .header p {
            font-size: 1.2rem;
            opacity: 0.9;
            max-width: 600px;
            margin: 0 auto;
        }
        
        .timer-content {
            padding: 50px 40px;
            text-align: center;
        }
        
        .time-display {
            font-size: 5rem;
            font-weight: 700;
            color: #1a2a6c;
            font-family: 'Courier New', monospace;
            margin: 30px 0;
            text-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
            letter-spacing: 5px;
        }
        
        .progress-container {
            height: 15px;
            background: #e9ecef;
            border-radius: 10px;
            overflow: hidden;
            margin: 40px 0;
            box-shadow: inset 0 1px 3px rgba(0,0,0,0.1);
        }
        
        .progress-bar {
            height: 100%;
            background: linear-gradient(to right, #1a2a6c, #3a5fc5);
            width: 0%;
            transition: width 1s linear;
            border-radius: 10px;
        }
        
        .redirect-info {
            background: #e8f4ff;
            border-radius: 15px;
            padding: 25px;
            border-left: 5px solid #1a2a6c;
            margin: 30px 0;
            text-align: left;
        }
        
        .redirect-info h3 {
            color: #1a2a6c;
            margin-bottom: 15px;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .redirect-url {
            font-weight: 600;
            color: #1a2a6c;
            word-break: break-all;
            font-size: 1.1rem;
            margin-top: 10px;
            padding: 10px 15px;
            background: white;
            border-radius: 8px;
            display: inline-block;
            border: 1px solid #d1e5ff;
        }
        
        .timer-stats {
            display: flex;
            justify-content: space-around;
            margin-top: 30px;
            flex-wrap: wrap;
        }
        
        .stat-card {
            background: #f8f9fa;
            border-radius: 15px;
            padding: 20px;
            min-width: 180px;
            margin: 10px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.05);
            border: 1px solid #e9ecef;
        }
        
        .stat-value {
            font-size: 2rem;
            font-weight: 700;
            color: #1a2a6c;
            margin: 10px 0;
        }
        
        .stat-label {
            color: #6c757d;
            font-weight: 600;
        }
        
        .footer {
            text-align: center;
            padding: 25px;
            background: #f8f9fa;
            color: #6c757d;
            border-top: 1px solid #e9ecef;
        }
        
        .completed-message {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.9);
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            z-index: 1000;
            opacity: 0;
            pointer-events: none;
            transition: opacity 0.5s ease;
        }
        
        .completed-message.show {
            opacity: 1;
            pointer-events: all;
        }
        
        .completed-content {
            background: white;
            padding: 50px;
            border-radius: 20px;
            text-align: center;
            max-width: 600px;
            width: 90%;
            transform: scale(0.8);
            animation: scaleIn 0.5s forwards;
        }
        
        @keyframes scaleIn {
            to {
                transform: scale(1);
            }
        }
        
        .completed-content h2 {
            font-size: 2.5rem;
            color: #1a2a6c;
            margin-bottom: 20px;
        }
        
        .completed-content p {
            font-size: 1.2rem;
            margin-bottom: 30px;
            color: #495057;
        }
        
        .redirect-btn {
            padding: 15px 40px;
            background: #1a2a6c;
            color: white;
            border: none;
            border-radius: 50px;
            font-size: 1.2rem;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s;
        }
        
        .redirect-btn:hover {
            background: #3a5fc5;
            transform: translateY(-3px);
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
        }
        
        /* Animation for timer */
        @keyframes pulse {
            0% { transform: scale(1); }
            50% { transform: scale(1.05); }
            100% { transform: scale(1); }
        }
        
        .pulse {
            animation: pulse 1s infinite;
        }
        
        /* Responsive design */
        @media (max-width: 768px) {
            .time-display {
                font-size: 3.5rem;
            }
            
            .header h1 {
                font-size: 2.2rem;
            }
            
            .timer-stats {
                flex-direction: column;
                align-items: center;
            }
        }
        
        @media (max-width: 480px) {
            .time-display {
                font-size: 2.5rem;
                letter-spacing: 3px;
            }
            
            .header h1 {
                font-size: 1.8rem;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1><i class="fas fa-hourglass-start"></i>Countdown Timer</h1>
            <p>This timer starts automatically and redirects when time expires</p>
        </div>
        
        <div class="timer-content">
            <div class="time-display" id="timeDisplay">00:01:00</div>
            
            <div class="progress-container">
                <div class="progress-bar" id="progressBar"></div>
            </div>
            
            <div class="redirect-info">
                <h3><i class="fas fa-external-link-alt"></i> Redirection Information</h3>
                <p>When the timer reaches zero, you will be automatically redirected to:</p>
                <p class="redirect-url" id="redirectDisplay"></p>
                <p>You will have 5 seconds to cancel the redirect if needed.</p>
            </div>
            
            <div class="timer-stats">
                <div class="stat-card">
                    <div class="stat-value" id="hoursStat">00</div>
                    <div class="stat-label">Hours</div>
                </div>
                <div class="stat-card">
                    <div class="stat-value" id="minutesStat">05</div>
                    <div class="stat-label">Minutes</div>
                </div>
                <div class="stat-card">
                    <div class="stat-value" id="secondsStat">00</div>
                    <div class="stat-label">Seconds</div>
                </div>
            </div>
        </div>
        
        <div class="footer">
            <p>Countdown Timer &copy; 2025 | Starts immediately and redirects when complete</p>
        </div>
    </div>
    
    <div class="completed-message" id="completedMessage">
        <div class="completed-content">
            <h2><i class="fas fa-check-circle"></i> Timer Complete!</h2>
            <p>You will be redirected to the specified URL in <span id="countdown">5</span> seconds.</p>
            <button class="redirect-btn" id="redirectNowBtn">
                <i class="fas fa-external-link-alt"></i> Go Now
            </button>
            <button class="redirect-btn" id="cancelBtn" style="background: #6c757d; margin-top: 15px;">
                <i class="fas fa-times"></i> Cancel Redirect
            </button>
        </div>
    </div>

    <script>
        // Timer configuration
        const timerConfig = {
            hours: 0,
            minutes: 1,
            seconds: 0,
            redirectUrl: "http://localhost/call_center_policy_admin/app/login.php"
        };
        
        // DOM Elements
        const timeDisplay = document.getElementById('timeDisplay');
        const progressBar = document.getElementById('progressBar');
        const redirectDisplay = document.getElementById('redirectDisplay');
        const completedMessage = document.getElementById('completedMessage');
        const countdownDisplay = document.getElementById('countdown');
        const redirectNowBtn = document.getElementById('redirectNowBtn');
        const cancelBtn = document.getElementById('cancelBtn');
        const hoursStat = document.getElementById('hoursStat');
        const minutesStat = document.getElementById('minutesStat');
        const secondsStat = document.getElementById('secondsStat');
        
        // Timer variables
        let totalSeconds = 0;
        let remainingSeconds = 0;
        let timerInterval = null;
        let redirectCountdown = null;
        
        // Initialize timer
        function initTimer() {
            // Calculate total seconds
            totalSeconds = timerConfig.hours * 3600 + timerConfig.minutes * 60 + timerConfig.seconds;
            remainingSeconds = totalSeconds;
            
            // Display redirect URL
            redirectDisplay.textContent = timerConfig.redirectUrl;
            
            // Set initial display
            updateDisplay();
            
            // Start the timer automatically
            startCountdown();
        }
        
        // Format time to HH:MM:SS
        function formatTime(seconds) {
            const hrs = Math.floor(seconds / 3600);
            const mins = Math.floor((seconds % 3600) / 60);
            const secs = seconds % 60;
            
            return `${hrs.toString().padStart(2, '0')}:${mins.toString().padStart(2, '0')}:${secs.toString().padStart(2, '0')}`;
        }
        
        // Update the display
        function updateDisplay() {
            timeDisplay.textContent = formatTime(remainingSeconds);
            
            // Update progress bar
            const progress = ((totalSeconds - remainingSeconds) / totalSeconds) * 100;
            progressBar.style.width = `${progress}%`;
            
            // Update stats
            hoursStat.textContent = Math.floor(remainingSeconds / 3600).toString().padStart(2, '0');
            minutesStat.textContent = Math.floor((remainingSeconds % 3600) / 60).toString().padStart(2, '0');
            secondsStat.textContent = (remainingSeconds % 60).toString().padStart(2, '0');
            
            // Add pulse animation when time is running out
            if (remainingSeconds <= 10) {
                timeDisplay.classList.add('pulse');
            } else {
                timeDisplay.classList.remove('pulse');
            }
        }
        
        // Start the countdown
        function startCountdown() {
            timerInterval = setInterval(() => {
                remainingSeconds--;
                
                // Update display
                updateDisplay();
                
                // Check if timer completed
                if (remainingSeconds <= 0) {
                    clearInterval(timerInterval);
                    showCompletionScreen();
                }
            }, 1000);
        }
        
        // Show completion screen
        function showCompletionScreen() {
            completedMessage.classList.add('show');
            
            // Start 5 second countdown for auto-redirect
            let countdown = 5;
            countdownDisplay.textContent = countdown;
            
            redirectCountdown = setInterval(() => {
                countdown--;
                countdownDisplay.textContent = countdown;
                
                if (countdown <= 0) {
                    clearInterval(redirectCountdown);
                    redirectToUrl();
                }
            }, 1000);
        }
        
        // Redirect to the specified URL
        function redirectToUrl() {
            window.location.href = timerConfig.redirectUrl;
        }
        
        // Cancel redirect
        function cancelRedirect() {
            clearInterval(redirectCountdown);
            completedMessage.classList.remove('show');
            
            // Reset timer to 5 seconds
            remainingSeconds = 5;
            totalSeconds = 5;
            updateDisplay();
            startCountdown();
        }
        
        // Event Listeners
        redirectNowBtn.addEventListener('click', redirectToUrl);
        cancelBtn.addEventListener('click', cancelRedirect);
        
        // Initialize the timer when page loads
        window.addEventListener('load', initTimer);
    </script>
</body>
</html>