<?php

// Include necessary files
include("session.php");
//Connect to Database
include("database.php");
//session_start();
require_once("preloader.php");
// Include the encryption/decryption functions
include("crypto_functions.php");

// Set the current date and time
$curr_date = date("Y-m-d");

// Sanitize and validate session data
$userindexn = isset($_SESSION['userindex']) ? htmlspecialchars(mysqli_real_escape_string($con, $_SESSION['userindex']), ENT_QUOTES, 'UTF-8') : '';
$name = isset($_SESSION['name']) ? htmlspecialchars(mysqli_real_escape_string($con, $_SESSION['name']), ENT_QUOTES, 'UTF-8') : '';
$last_login_date = isset($_SESSION['last_login_date']) ? htmlspecialchars(mysqli_real_escape_string($con, $_SESSION['last_login_date']), ENT_QUOTES, 'UTF-8') : '';
$username = isset($_SESSION['username']) ? htmlspecialchars(mysqli_real_escape_string($con, $_SESSION['username']), ENT_QUOTES, 'UTF-8') : '';
$user_sub_priv = isset($_SESSION['user_sub_priv']) ? htmlspecialchars(mysqli_real_escape_string($con, $_SESSION['user_sub_priv']), ENT_QUOTES, 'UTF-8') : '';
$branchindex = isset($_SESSION['branchindex']) ? htmlspecialchars(mysqli_real_escape_string($con, $_SESSION['branchindex']), ENT_QUOTES, 'UTF-8') : '';
$full_name = isset($_SESSION['name']) ? htmlspecialchars(mysqli_real_escape_string($con, $_SESSION['name']), ENT_QUOTES, 'UTF-8') : '';



// Direct dashboard access for specific user privileges

$display_location="dashboard.php?id=";

// Encrypt the data
$data = $userindexn;
$encrypted = encrypt($data);



// Format the last login date securely
if (!empty($last_login_date)) {
  $last_login_date = date("d-m-Y h:i:s", strtotime($last_login_date));
}

// Retrieve organization data securely
$result_search = mysqli_query($con, "SELECT companyindex, company_logo FROM company");
if (!$result_search) {
  // Log the error message securely and avoid revealing sensitive information
  error_log("Database error: " . mysqli_error($con), 0);
  die("An error occurred while fetching company data.");
}

// Fetch data securely
$test_search = mysqli_fetch_array($result_search, MYSQLI_ASSOC);
$banner_logo = isset($test_search['company_logo']) ? htmlspecialchars($test_search['company_logo'], ENT_QUOTES, 'UTF-8') : '';

?>

<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8" />
  <link rel="apple-touch-icon" sizes="76x76" href="../assets/img/apple-icon.png">
  <link rel="icon" type="image/png" href="../assets/img/favicon.png">
  <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />
  <title>
MMAIN MENU PAGE
  </title>
  <meta content='width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0, shrink-to-fit=no' name='viewport' />
  <!--     Fonts and icons     -->
  <link rel="stylesheet" href="css/google-fonts.css" type="text/css">
  <link rel="stylesheet" href="css/font-awesome.min.css">
  <link rel="stylesheet" href="css/cstyles.css">
  <link rel="stylesheet" href="css/quill_snow.css" type="text/css">
  <link rel="stylesheet" href="css/upload-container.css" type="text/css">
  <link rel="stylesheet" href="css/font_momo_page.css" type="text/css">

  <!-- CSS Files -->
  <link href="../assets/css/material-dashboard.css?v=2.1.1" rel="stylesheet" />
  
  <!-- CSS Just for demo purpose, don't include it in your project -->
  <link href="../assets/demo/demo.css" rel="stylesheet" />
  <script type="text/javascript" src="js/loader.js"></script>
  <script type="text/javascript" src="js/chart.js"></script>
  <script type="text/javascript" src="js/xlsx.full.min.js"></script>
  <script type="text/javascript" src="js/quill.min.js"></script>
  <script type="text/javascript" src="js/jquery-3.6.0.min.js"></script>
  <script type="text/javascript" src="js/dash_board.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<!-- Make sure it's Bootstrap 4 or compatible -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>
 <!-- Bootstrap 5 CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <!-- Bootstrap Icons -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
  <!-- Bootstrap Bundle JS -->
   <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
  </head>

<body class="">
  <div class="wrapper ">
    <div class="sidebar" data-color="purple" data-background-color="white" data-image="/assets/img/sidebar-1.jpg">
      <!--
        Tip 1: You can change the color of the sidebar using: data-color="purple | azure | green | orange | danger"

        Tip 2: you can also add an image using data-image tag
    -->   <div class="logo" style="text-align: center;">
  <a class="navbar-brand" href="#pablo">
    <img src="images/<?php echo $banner_logo; ?>" width="160" height="60" alt="banner">
  </a>
</div>

<div class="sidebar-wrapper">
  <ul class="nav">
    <li class="nav-item active">
      <a class="nav-link" href="<?php echo $display_location.$encrypted; ?>" style="background: #6ec1e4; color: white; text-align: center; padding: 15px;">
        <i class="material-icons" ><strong>dashboard</strong></i>
        <p><strong>dashboard</strong></p>
      </a>
    </li>

      	<?php
// Script to generate blue-colored menu with submenus
$stmt = $con->prepare("SELECT users_priv_path_index, users_priv_path_name, users_priv_path, 
                        users_priv_path_symbols, users_priv_path_code 
                        FROM users_priv_path 
                        WHERE users_priv_sub_priv_index = ?");
$stmt->bind_param("s", $user_sub_priv);
$stmt->execute();
$resultMainMenu = $stmt->get_result();

// Add this style block at the top of your page or in your CSS file
echo '<style>
        .blue-menu .nav-link {
            color: #1976D2 !important;
        }
        .blue-menu .nav-link:hover {
            color: #0D47A1 !important;
            background-color: rgba(25, 118, 210, 0.1) !important;
        }
        .blue-menu .nav-link.active {
            color: #0D47A1 !important;
            font-weight: 500;
        }
        .blue-menu .material-icons {
            color: #1976D2 !important;
        }
        .blue-menu .nav {
            background-color: rgba(25, 118, 210, 0.05) !important;
        }
        .blue-menu .caret {
            border-top: 4px solid #1976D2;
        }
            .notification-badge {
  position: absolute;
  top: 5px;
  right: 5px;
  padding: 3px 6px;
  border-radius: 50%;
  background: #ff5252;
  color: white;
  font-size: 12px;
}

.nav-item.dropdown {
  position: relative;
}

.dropdown-notifications {
  min-width: 250px;
  padding: 0;
}
      </style>';

// Loop through each main menu item
while ($mainMenuItem = $resultMainMenu->fetch_assoc()) {
    $mainMenuId = $mainMenuItem['users_priv_path_index'];
    $users_priv_path_name = htmlspecialchars($mainMenuItem['users_priv_path_name'], ENT_QUOTES, 'UTF-8');
    $users_priv_pathn = htmlspecialchars($mainMenuItem['users_priv_path'], ENT_QUOTES, 'UTF-8');
    $users_priv_path_symbols = htmlspecialchars($mainMenuItem['users_priv_path_symbols'], ENT_QUOTES, 'UTF-8');
    $users_priv_path_code = htmlspecialchars($mainMenuItem['users_priv_path_code'], ENT_QUOTES, 'UTF-8');
    
    // Check if this menu item has sub-items
    $stmtSub = $con->prepare("SELECT sub_users_priv_path_name, sub_users_priv_path, 
                             sub_users_priv_path_code, sub_users_priv_path_symbols 
                             FROM sub_users_priv_path 
                             WHERE sub_users_priv_path_index = ?");
    $stmtSub->bind_param("s", $mainMenuId);
    $stmtSub->execute();
    $resultSubMenu = $stmtSub->get_result();
    
    $hasSubMenu = $resultSubMenu->num_rows > 0;
    
    // Path Encrypt for main menu item
    $users_priv_path = !empty($users_priv_pathn) ? 
        $users_priv_pathn . '?id=' . urlencode($encrypted).'&'.$users_priv_path_code : '#';
    
    if ($hasSubMenu) {
        // Output as a dropdown menu item
        echo '<li class="nav-item">
                <a class="nav-link collapsed blue-menu" data-toggle="collapse" href="#submenu-'.$mainMenuId.'" aria-expanded="false">
                  <i class="material-icons">'.$users_priv_path_symbols.'</i>
                  <p>'.$users_priv_path_name.'
                    <b class="caret"></b>
                  </p>
                </a>
                <div class="collapse" id="submenu-'.$mainMenuId.'">
                  <ul class="nav blue-menu">';
        
        // Loop through submenu items
        while ($subMenuItem = $resultSubMenu->fetch_assoc()) {
            $sub_users_priv_path_name = htmlspecialchars($subMenuItem['sub_users_priv_path_name'], ENT_QUOTES, 'UTF-8');
            $sub_users_priv_pathn = htmlspecialchars($subMenuItem['sub_users_priv_path'], ENT_QUOTES, 'UTF-8');
            $sub_users_priv_path_symbols = htmlspecialchars($subMenuItem['sub_users_priv_path_symbols'], ENT_QUOTES, 'UTF-8');
            $sub_users_priv_path_code = htmlspecialchars($subMenuItem['sub_users_priv_path_code'], ENT_QUOTES, 'UTF-8');
            
            $sub_users_priv_path = !empty($sub_users_priv_pathn) ? 
                $sub_users_priv_pathn . '?id=' . urlencode($encrypted).'&'.$sub_users_priv_path_code : '#';
            
            echo '<li class="nav-item">
                    <a class="nav-link" href="'.$sub_users_priv_path.'">
                      <i class="material-icons">'.$sub_users_priv_path_symbols.'</i>
                      <p>'.$sub_users_priv_path_name.'</p>
                    </a>
                  </li>';
        }
        
        echo '</ul>
            </div>
          </li>';
    } else {
        // Output as a regular menu item
        echo '<li class="nav-item">
                <a class="nav-link blue-menu" href="'.$users_priv_path.'">
                  <i class="material-icons">'.$users_priv_path_symbols.'</i>
                  <p>'.$users_priv_path_name.'</p>
                </a>
              </li>';
    }
}
?>    
   </ul>
      </div>
    </div>  
    
    <div class="main-panel">

	
      <nav class="navbar navbar-expand-lg navbar-transparent navbar-absolute fixed-top ">
        <div class="container-fluid">

          <button class="navbar-toggler" type="button" data-toggle="collapse" aria-controls="navigation-index" aria-expanded="false" aria-label="Toggle navigation">
            <span class="sr-only">Toggle navigation</span>
            <span class="navbar-toggler-icon icon-bar"></span>
            <span class="navbar-toggler-icon icon-bar"></span>
            <span class="navbar-toggler-icon icon-bar"></span>
          </button>
          <div class="collapse navbar-collapse justify-content-end" >
            


  <!-- Empty Dropdown Item (Placeholder) -->
  <li class="nav-item dropdown">
    <a class="nav-link" href="#" id="navbarDropdownMenuLink2" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
      <i class="material-icons"></i>      
      <p class="d-lg-none d-md-block"></p>
    </a>
  </li>

  <!-- Profile Dropdown -->
  <li class="nav-item dropdown">
    <a class="nav-link" href="#pablo" id="navbarDropdownProfile" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
      <i class="material-icons">person</i>
      <p class="d-lg-none d-md-block"></p>
    </a>
    <div class="dropdown-menu dropdown-menu-right" aria-labelledby="navbarDropdownProfile">
      <a class="dropdown-item" href="login_changepassword.php?id=<?php echo $encrypted_string ?>">Change Password</a>
      <div class="dropdown-divider"></div>
      <a class="dropdown-item" href="logout_session.php">Log out</a>
    </div>
  </li>
</ul>
              </li>
            </ul>
          </div>
        </div>
      </nav> 
      
  <!--   Core JS Files   -->
  <script src="../assets/js/core/jquery.min.js"></script>
  <script src="../assets/js/core/popper.min.js"></script>
  <script src="../assets/js/core/bootstrap-material-design.min.js"></script>
  <script src="../assets/js/plugins/perfect-scrollbar.jquery.min.js"></script>
  <!-- Plugin for the momentJs  -->
  <script src="../assets/js/plugins/moment.min.js"></script>
  <!--  Plugin for Sweet Alert -->
  <script src="../assets/js/plugins/sweetalert2.js"></script>
  <!-- Forms Validations Plugin -->
  <script src="../assets/js/plugins/jquery.validate.min.js"></script>
  <!-- Plugin for the Wizard, full documentation here: https://github.com/VinceG/twitter-bootstrap-wizard -->
  <script src="../assets/js/plugins/jquery.bootstrap-wizard.js"></script>
  <!--	Plugin for Select, full documentation here: http://silviomoreto.github.io/bootstrap-select -->
  <script src="../assets/js/plugins/bootstrap-selectpicker.js"></script>
  <!--  Plugin for the DateTimePicker, full documentation here: https://eonasdan.github.io/bootstrap-datetimepicker/ -->
  <script src="../assets/js/plugins/bootstrap-datetimepicker.min.js"></script>
  <!--  DataTables.net Plugin, full documentation here: https://datatables.net/  -->
  <script src="../assets/js/plugins/jquery.dataTables.min.js"></script>
  <!--	Plugin for Tags, full documentation here: https://github.com/bootstrap-tagsinput/bootstrap-tagsinputs  -->
  <script src="../assets/js/plugins/bootstrap-tagsinput.js"></script>
  <!-- Plugin for Fileupload, full documentation here: http://www.jasny.net/bootstrap/javascript/#fileinput -->
  <script src="../assets/js/plugins/jasny-bootstrap.min.js"></script>
  <!--  Full Calendar Plugin, full documentation here: https://github.com/fullcalendar/fullcalendar    -->
  <script src="../assets/js/plugins/fullcalendar.min.js"></script>
  <!-- Vector Map plugin, full documentation here: http://jvectormap.com/documentation/ -->
  <script src="../assets/js/plugins/jquery-jvectormap.js"></script>
  <!--  Plugin for the Sliders, full documentation here: http://refreshless.com/nouislider/ -->
  <script src="../assets/js/plugins/nouislider.min.js"></script>
  <!-- Include a polyfill for ES6 Promises (optional) for IE11, UC Browser and Android browser support SweetAlert -->
  <script src="https://cdnjs.cloudflare.com/ajax/libs/core-js/2.4.1/core.js"></script>
  <!-- Library for adding dinamically elements -->
  <script src="../assets/js/plugins/arrive.min.js"></script>
  <!--  Google Maps Plugin    -->
  <script src="https://maps.googleapis.com/maps/api/js?key=YOUR_KEY_HERE"></script>
  <!-- Chartist JS -->
  <script src="../assets/js/plugins/chartist.min.js"></script>
  <!--  Notifications Plugin    -->
  <script src="../assets/js/plugins/bootstrap-notify.js"></script>
  <!-- Control Center for Material Dashboard: parallax effects, scripts for the example pages etc -->
  <script src="../assets/js/material-dashboard.js?v=2.1.1" type="text/javascript"></script>
  <!-- Material Dashboard DEMO methods, don't include it in your project! -->
  <script src="../assets/demo/demo.js"></script>
  <script>
    $(document).ready(function() {
      $().ready(function() {
        $sidebar = $('.sidebar');

        $sidebar_img_container = $sidebar.find('.sidebar-background');

        $full_page = $('.full-page');

        $sidebar_responsive = $('body > .navbar-collapse');

        window_width = $(window).width();

        fixed_plugin_open = $('.sidebar .sidebar-wrapper .nav li.active a p').html();

        if (window_width > 767 && fixed_plugin_open == 'Dashboard') {
          if ($('.fixed-plugin .dropdown').hasClass('show-dropdown')) {
            $('.fixed-plugin .dropdown').addClass('open');
          }

        }

        $('.fixed-plugin a').click(function(event) {
          // Alex if we click on switch, stop propagation of the event, so the dropdown will not be hide, otherwise we set the  section active
          if ($(this).hasClass('switch-trigger')) {
            if (event.stopPropagation) {
              event.stopPropagation();
            } else if (window.event) {
              window.event.cancelBubble = true;
            }
          }
        });

        $('.fixed-plugin .active-color span').click(function() {
          $full_page_background = $('.full-page-background');

          $(this).siblings().removeClass('active');
          $(this).addClass('active');

          var new_color = $(this).data('color');

          if ($sidebar.length != 0) {
            $sidebar.attr('data-color', new_color);
          }

          if ($full_page.length != 0) {
            $full_page.attr('filter-color', new_color);
          }

          if ($sidebar_responsive.length != 0) {
            $sidebar_responsive.attr('data-color', new_color);
          }
        });

        $('.fixed-plugin .background-color .badge').click(function() {
          $(this).siblings().removeClass('active');
          $(this).addClass('active');

          var new_color = $(this).data('background-color');

          if ($sidebar.length != 0) {
            $sidebar.attr('data-background-color', new_color);
          }
        });

        $('.fixed-plugin .img-holder').click(function() {
          $full_page_background = $('.full-page-background');

          $(this).parent('li').siblings().removeClass('active');
          $(this).parent('li').addClass('active');


          var new_image = $(this).find("img").attr('src');

          if ($sidebar_img_container.length != 0 && $('.switch-sidebar-image input:checked').length != 0) {
            $sidebar_img_container.fadeOut('fast', function() {
              $sidebar_img_container.css('background-image', 'url("' + new_image + '")');
              $sidebar_img_container.fadeIn('fast');
            });
          }

          if ($full_page_background.length != 0 && $('.switch-sidebar-image input:checked').length != 0) {
            var new_image_full_page = $('.fixed-plugin li.active .img-holder').find('img').data('src');

            $full_page_background.fadeOut('fast', function() {
              $full_page_background.css('background-image', 'url("' + new_image_full_page + '")');
              $full_page_background.fadeIn('fast');
            });
          }

          if ($('.switch-sidebar-image input:checked').length == 0) {
            var new_image = $('.fixed-plugin li.active .img-holder').find("img").attr('src');
            var new_image_full_page = $('.fixed-plugin li.active .img-holder').find('img').data('src');

            $sidebar_img_container.css('background-image', 'url("' + new_image + '")');
            $full_page_background.css('background-image', 'url("' + new_image_full_page + '")');
          }

          if ($sidebar_responsive.length != 0) {
            $sidebar_responsive.css('background-image', 'url("' + new_image + '")');
          }
        });

        $('.switch-sidebar-image input').change(function() {
          $full_page_background = $('.full-page-background');

          $input = $(this);

          if ($input.is(':checked')) {
            if ($sidebar_img_container.length != 0) {
              $sidebar_img_container.fadeIn('fast');
              $sidebar.attr('data-image', '#');
            }

            if ($full_page_background.length != 0) {
              $full_page_background.fadeIn('fast');
              $full_page.attr('data-image', '#');
            }

            background_image = true;
          } else {
            if ($sidebar_img_container.length != 0) {
              $sidebar.removeAttr('data-image');
              $sidebar_img_container.fadeOut('fast');
            }

            if ($full_page_background.length != 0) {
              $full_page.removeAttr('data-image', '#');
              $full_page_background.fadeOut('fast');
            }

            background_image = false;
          }
        });

        $('.switch-sidebar-mini input').change(function() {
          $body = $('body');

          $input = $(this);

          if (md.misc.sidebar_mini_active == true) {
            $('body').removeClass('sidebar-mini');
            md.misc.sidebar_mini_active = false;

            $('.sidebar .sidebar-wrapper, .main-panel').perfectScrollbar();

          } else {

            $('.sidebar .sidebar-wrapper, .main-panel').perfectScrollbar('destroy');

            setTimeout(function() {
              $('body').addClass('sidebar-mini');

              md.misc.sidebar_mini_active = true;
            }, 300);
          }

          // we simulate the window Resize so the charts will get updated in realtime.
          var simulateWindowResize = setInterval(function() {
            window.dispatchEvent(new Event('resize'));
          }, 180);

          // we stop the simulation of Window Resize after the animations are completed
          setTimeout(function() {
            clearInterval(simulateWindowResize);
          }, 1000);

        });
      });
    });
  </script>
  <script>
    $(document).ready(function() {
      // Javascript method's body can be found in assets/js/demos.js
      md.initDashboardPageCharts();

    });
  </script>
</body>

</html>

