<?php
//ini_set('display_errors', 1);
//ini_set('display_startup_errors', 1);
//error_reporting(E_ALL);
//include("session.php");

//Connect to Database
include("database.php");
//require_once('crypto_functions.php');


// Include the encryption/decryption functions



$msg 			= 	htmlspecialchars(filter_var(mysqli_real_escape_string($con,$_REQUEST['msg']),FILTER_SANITIZE_STRING));
$sr 			= 	htmlspecialchars(filter_var(mysqli_real_escape_string($con,$_REQUEST['sr']),FILTER_SANITIZE_STRING));



// Validate and decrypt input securely
$encrypted_string = $_GET['urc'] ?? '';
$decrypted_string = '';
if (!empty($encrypted_string)) {
    $decrypted_string = filter_var($encrypted_string, FILTER_SANITIZE_STRING);
}

// Prepare the query securely
if (!empty($decrypted_string)) {
    $query = "SELECT companyindex, company_name, company_address, company_tel, company_email 
              FROM company 
              WHERE company_name LIKE ? OR company_tel LIKE ? 
              ORDER BY companyindex DESC";
    $stmt = $con->prepare($query);
    $search_param = '%' . $decrypted_string . '%';
    $stmt->bind_param("ss", $search_param, $search_param);
} else {
    $query = "SELECT companyindex, company_name, company_address, company_tel, company_email 
              FROM company 
              ORDER BY companyindex DESC";
    $stmt = $con->prepare($query);
}
$stmt->execute();
$result = $stmt->get_result();

?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0, shrink-to-fit=no" />
    <title>View Organization Report</title>
    <link href="../assets/css/material-dashboard.css?v=2.1.1" rel="stylesheet" />
    <link href="../assets/demo/demo.css" rel="stylesheet" />
</head>

<body>
<?php include 'main_menu.php'; ?>

<style>
        body {
    background-image: url('images/ayo_banner4.png'); /* Replace with your actual image path */
    background-size: cover;
  background-position: center;
    background-repeat: no-repeat;
    background-attachment: fixed;
    opacity: 0.9; /* Adjust transparency (0.1 to 1) */
}

body::before {
    content: "";
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-image: url('images/ayo_banner4.png');
    background-size: cover;
    background-position: center;
    background-repeat: no-repeat;
    background-attachment: fixed;
    opacity: 0.5; /* Adjust transparency */
    z-index: -1;
}

</style>
<script type="text/javascript">
window.onload = function(){ 
               
   if (form.msg.value == "") {
    return false ;
  }
      if(form.msg.value == "10$202?c") {
    alert("Updated Successfully");
    form.msg.focus();
    return false ;
  } 
  

  if(form.msg.value == "10$203?c") {
    alert("Deleted");
    form.msg.focus();
    return false ;
  } 
  

}
</script>

<form id="form" name="form" method="POST" action="" enctype="multipart/form-data">
<input type="hidden" name="msg" value="<?php echo htmlspecialchars($msg); ?>">
</form>

<div class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                     <div class="card-header card-header-primary" style="background: #6ec1e4; color: white; text-align: center; padding: 15px;">
                       <h4 class="card-title" style="color:rgb(10, 44, 234); font-weight: bold; text-align: center;">View Organization Report</h4>
                        <p class="card-category">
                            <a href="org_report.php?sr=716!b100" id="export_button" class="btn btn-primary btn-lick">Click Here To Extract To Excel</a>
                        </p>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table" id="report_data">
                                <thead class="text-primary">
                                    <tr>
                                        <th>No.</th>
                                        <th>Name</th>
                                        <th>Address</th>
                                        <th>Telephone</th>
                                        <th>Email</th>
                                        <th>Controls</th>
                                        <th>
                                            <a href="org_add.php" rel="tooltip" title="Add New" class="btn btn-primary btn-link btn-sm">
                                                <i class="material-icons">save</i>
                                            </a>
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                <?php
                                $no = 0;
                                while ($row = $result->fetch_assoc()) {
                                    $no++;
                                    $company_name = htmlspecialchars($row['company_name']);
                                    $company_address = htmlspecialchars($row['company_address']);
                                    $company_tel = htmlspecialchars($row['company_tel']);
                                    $company_email = htmlspecialchars($row['company_email']);
                                    $companyindex = htmlspecialchars($row['companyindex']);

// Encrypt the data
$companyindexn = encrypt($companyindex);
$companyindexn = urlencode($companyindexn);
                                    

                                     echo "<tr>
                                            <td>{$no}</td>
                                            <td>{$company_name}</td>
                                            <td>{$company_address}</td>
                                            <td>{$company_tel}</td>
                                            <td class='text-primary'>{$company_email}</td>
                                            <td class='td-actions text-centre'>
                                                <a href='org_edit.php?id={$companyindexn}&sr=$sr' rel='tooltip' title='Edit Task' class='btn btn-primary btn-link btn-sm'>
                                                    <i class='material-icons'>edit</i>
                                                </a>
                                                <a href='org_add_delete_approval.php?id={$companyindexn}&sr=$sr' rel='tooltip' title='Remove Task' class='btn btn-danger btn-link btn-sm'>
                                                    <i class='material-icons'>close</i>
                                                </a>
                                            </td>
                                        </tr>";
                                }
                                ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
   <?php include 'footer.php' ?>
	  <script>
    function html_table_to_excel(type)
    {
        var data = document.getElementById('report_data');

        var file = XLSX.utils.table_to_book(data, {sheet: "sheet1"});

        XLSX.write(file, { bookType: type, bookSST: true, type: 'base64' });

        XLSX.writeFile(file, 'file.' + type);
    }

    const export_button = document.getElementById('export_button');

    export_button.addEventListener('click', () =>  {
        html_table_to_excel('xlsx');
    });

</script>