<?php

//ini_set('display_errors', 1);
//ini_set('display_startup_errors', 1);
//error_reporting(E_ALL);


// Connect to Database
include("database.php");
require_once('crypto_functions.php');
include('log_functions.php');  
include('get_total_premium_functions.php');   
include('policy_endorsement_functions.php');   
include('endorsement_batch_policyholder.php');   
include("session.php");


// Get user index (assume numeric)
$userindex = isset($_SESSION['userindex']) ? (int)$_SESSION['userindex'] : 0;


// Initialize variables
$success_message = '';
$error_message = '';



//request endorsement_type
$endorsement_type = 	htmlspecialchars(filter_var(mysqli_real_escape_string($con,$_REQUEST['endorsement_type']),FILTER_SANITIZE_STRING));
//$telco_network = 	htmlspecialchars(filter_var(mysqli_real_escape_string($con,$_REQUEST['telco_network']),FILTER_SANITIZE_STRING));



// Check if we're editing an existing record (from URL parameter)
$edit_mode = false;
$existing_data = array();

// Check if ID parameter exists for editing
if (isset($_REQUEST['id']) && !empty($_REQUEST['id'])) {
    $id = mysqli_real_escape_string($con, $_REQUEST['id']);
    
    // Try to decrypt if it's encrypted
    try {
        $decrypted_id = decrypt($id);
        $subscriber_id = is_numeric($decrypted_id) ? (int)$decrypted_id : (int)$id;
    } catch (Exception $e) {
        $subscriber_id = (int)$id;
    }
    
    // If we have a valid subscriber ID, fetch existing data
    if ($subscriber_id > 0) {
        $edit_mode = true;
        
        // Prepare query using the correct column name
        $stmt = $con->prepare("
            SELECT 
                subscriptions_id,
                mobile_money_number,
                full_name,
                date_of_birth,
                gender,
                policy_number,
                product_name,
                premium,
                payment_status,
                onboarding_channel,
                type,
                momo_network,
                total_premium              
            FROM subscription_main
            WHERE subscriptions_id = ?
        ");
        
        if ($stmt) {
            $stmt->bind_param("i", $subscriber_id);
            $stmt->execute();
            $result_search = $stmt->get_result();
            
            if ($result_search->num_rows > 0) {
                $existing_data = $result_search->fetch_assoc();
                
                // Assign existing values to variables
                $mobile_money_number = htmlspecialchars($existing_data['mobile_money_number'] ?? '', ENT_QUOTES, 'UTF-8');
                $full_name_main = htmlspecialchars($existing_data['full_name'] ?? '', ENT_QUOTES, 'UTF-8');
                $date_of_birth = htmlspecialchars($existing_data['date_of_birth'] ?? '', ENT_QUOTES, 'UTF-8');
                $gender = htmlspecialchars($existing_data['gender'] ?? '', ENT_QUOTES, 'UTF-8');
                $policy_number = htmlspecialchars($existing_data['policy_number'] ?? '', ENT_QUOTES, 'UTF-8');
                $product_name = htmlspecialchars($existing_data['product_name'] ?? '', ENT_QUOTES, 'UTF-8');
                $premiums = htmlspecialchars($existing_data['premium'] ?? '', ENT_QUOTES, 'UTF-8');
                $payment_status = htmlspecialchars($existing_data['payment_status'] ?? '', ENT_QUOTES, 'UTF-8');
                $onboarding_channel = htmlspecialchars($existing_data['onboarding_channel'] ?? '', ENT_QUOTES, 'UTF-8');
                $type = htmlspecialchars($existing_data['type'] ?? '', ENT_QUOTES, 'UTF-8');
                $telco_network = htmlspecialchars($existing_data['momo_network'] ?? '', ENT_QUOTES, 'UTF-8');          
                
                //previous value
                $mobile_money_numbern = htmlspecialchars($existing_data['mobile_money_number'] ?? '', ENT_QUOTES, 'UTF-8');
                $full_name_mainn = htmlspecialchars($existing_data['full_name'] ?? '', ENT_QUOTES, 'UTF-8');
                $date_of_birthn = htmlspecialchars($existing_data['date_of_birth'] ?? '', ENT_QUOTES, 'UTF-8');              
                //$premiumsn = htmlspecialchars($existing_data['total_premium'] ?? '', ENT_QUOTES, 'UTF-8');    
                 $total_premium = htmlspecialchars($existing_data['total_premium'] ?? '', ENT_QUOTES, 'UTF-8');
                 //$total_premiumn = htmlspecialchars($existing_data['total_premium'] ?? '', ENT_QUOTES, 'UTF-8');             
                //$telco_networkn = htmlspecialchars($existing_data['momo_network'] ?? '', ENT_QUOTES, 'UTF-8');
                
                }
            $stmt->close();
        }
    }
}





// Select from subscription_mandate_sub
$result_search = mysqli_query(
    $con,
    "SELECT frequency,momo_network 
     FROM subscription_mandate_sub 
     WHERE subscriptions_id = '$subscriber_id'"
);
if (!$result_search) {
    die("Database error: " . mysqli_error($con));
}
if (mysqli_num_rows($result_search) > 0) {
    $test_search = mysqli_fetch_assoc($result_search);
    $frequencyn = trim($test_search['frequency']);
    $frequency = trim($test_search['frequency']);

    $telco_network = trim($test_search['momo_network']); 
    $telco_networkn = trim($test_search['momo_network']);   
} else {
    $frequencyn = ''; // or handle "not found" case
    $frequency = ''; // or handle "not found" case
    $telco_network = '';
    $telco_networkn = '';
}




// Search Additional Lifes (multiple records)
$additional_lifes = array();
$stmt_additional = $con->prepare("
    SELECT 
        subscriptions_id_addtional,
        mobile_money_number,
        full_name,
        date_of_birth,
        gender,
        relationship,
        premium,
        `date`
    FROM subscription_additionallife
    WHERE subscriptions_id = ?
    ORDER BY subscriptions_id_addtional DESC
");

if ($stmt_additional) {
    $stmt_additional->bind_param("i", $subscriber_id);
    if ($stmt_additional->execute()) {
        $result_additional = $stmt_additional->get_result();
        while ($row = $result_additional->fetch_assoc()) {
            $additional_lifes[] = array(
                'subscriptions_id_addtional' => htmlspecialchars($row['subscriptions_id_addtional'] ?? '', ENT_QUOTES, 'UTF-8'),
                'mobile_money_number' => htmlspecialchars($row['mobile_money_number'] ?? '', ENT_QUOTES, 'UTF-8'),
                'full_name' => htmlspecialchars($row['full_name'] ?? '', ENT_QUOTES, 'UTF-8'),
                'date_of_birth' => htmlspecialchars($row['date_of_birth'] ?? '', ENT_QUOTES, 'UTF-8'),
                'gender' => htmlspecialchars($row['gender'] ?? '', ENT_QUOTES, 'UTF-8'),
                'relationship' => htmlspecialchars($row['relationship'] ?? '', ENT_QUOTES, 'UTF-8'),
                'premium' => htmlspecialchars($row['premium'] ?? '', ENT_QUOTES, 'UTF-8'),
                'date' => htmlspecialchars($row['date'] ?? '', ENT_QUOTES, 'UTF-8')
            );
        }
    }
    $stmt_additional->close();
}

// Search Subscription Beneficiaries (multiple records)
$subscription_beneficiaries = array();
$stmt_beneficiaries = $con->prepare("
    SELECT 
        subscription_beneficiary_id,
        subscriptions_id,
        full_name,
        relationship,
        mobile_money_number,
        created_at
    FROM subscription_beneficiaries
    WHERE subscriptions_id = ?
    ORDER BY subscription_beneficiary_id DESC
");

if ($stmt_beneficiaries) {
    $stmt_beneficiaries->bind_param("i", $subscriber_id);
    if ($stmt_beneficiaries->execute()) {
        $result_beneficiaries = $stmt_beneficiaries->get_result();
        while ($row = $result_beneficiaries->fetch_assoc()) {
            $subscription_beneficiaries[] = array(
                'subscription_beneficiary_id' => htmlspecialchars($row['subscription_beneficiary_id'] ?? '', ENT_QUOTES, 'UTF-8'),
                'full_name' => htmlspecialchars($row['full_name'] ?? '', ENT_QUOTES, 'UTF-8'),
                'relationship' => htmlspecialchars($row['relationship'] ?? '', ENT_QUOTES, 'UTF-8'),
                'mobile_money_number' => htmlspecialchars($row['mobile_money_number'] ?? '', ENT_QUOTES, 'UTF-8'),
                'created_at' => htmlspecialchars($row['created_at'] ?? '', ENT_QUOTES, 'UTF-8')
            );
        }
    }
    $stmt_beneficiaries->close();
}

//if its success the green or else red
$color = '';

if ($payment_status === 'Failed') {
    $color = 'red';
} elseif ($payment_status === 'Success') {
    $color = 'green';
}

// Initialize variables
$success_message = '';
$error_message = '';

// Handle form submission for subscription_main UPDATE ONLY
if (isset($_POST['submit_main'])) {
    if ($subscriber_id <= 0) {
        $error_message = "Error: Cannot update without a valid subscription ID.";
    } else {
        // Sanitize and validate inputs
        $mobile_money_number = trim($_POST['mobile_money_number']);
        $full_name_main = trim($_POST['full_name_main']);
        $date_of_birth = trim($_POST['date_of_birth']);
        $gender = trim($_POST['gender']);
        $policy_number = trim($_POST['policy_number']);
        $product_name = trim($_POST['product_name']);
        $premiums = floatval($_POST['premiums']);
        $payment_status = trim($_POST['payment_status']);
        $onboarding_channel = trim($_POST['onboarding_channel']);
        $telco_network = trim($_POST['telco_network']);
        $frequency = trim($_POST['frequency']);
        

               //previous
        $mobile_money_numbern = trim($_POST['mobile_money_numbern']);
        $full_name_mainn = trim($_POST['full_name_mainn']);
        $date_of_birthn = trim($_POST['date_of_birthn']);  
        //$premiumsn = floatval($_POST['premiumsn']);
        $telco_networkn = trim($_POST['telco_networkn']);
        $frequencyn = trim($_POST['frequencyn']);
        
        
//echo $premiums.' '.$total_premiumcc.' '.$total_premium;exit;

        //endorsement 
        $endorsement_type = trim($_POST['endorsement_type']);
        $effective_date = trim($_POST['effective_date']);
        $remarks = trim($_POST['remarks']);



//get total premium function
if ($endorsement_type == 'Premium') {
$data = getPremiumForAdditionalLives($con, $subscriber_id, $premiums);
$count         = $data['count'];
$premium_mains = $data['premium_main'];
$premium_one   = $data['premium_one'];
$premium_two   = $data['premium_two'];
if ($count == 0) {
    $total_premiumcc = $premium_mains;
} 

elseif ($count == 1) {
    $total_premiumcc = $premium_one;
} 
elseif ($count == 2) {
    $total_premiumcc = $premium_two;  
}
}


//check if total_premiumcc is emoty
if ($total_premiumcc == '') {
 $total_premiumcc = $total_premium;      
}

if ($endorsement_type === 'Main Life Name') {
    $previous_value = $full_name_mainn;   // old
    $new_value      = $full_name_main;    // new
}

elseif ($endorsement_type === 'Main Life Dob') {
    $previous_value = $date_of_birthn;
    $new_value      = $date_of_birth;
}

elseif ($endorsement_type === 'Mobile Wallet Number') {
    $previous_value = $mobile_money_numbern;
    $new_value      = $mobile_money_number;
}

elseif ($endorsement_type === 'Premium') {
    $previous_value = $total_premium;          // old premium
    $new_value      = $total_premiumcc;     // new premium
}

    elseif ($endorsement_type === 'Telco') {
    $previous_value = $telco_networkn;          // old premium
    $new_value      = $telco_network;     // new premium
}  

    elseif ($endorsement_type === 'Telco') {
    $previous_value = $telco_networkn;          // old premium
    $new_value      = $telco_network;     // new premium
}  
     
    elseif ($endorsement_type === 'Frequency') {
    $previous_value = $frequencyn;          // old premium
    $new_value      = $frequency;     // new premium
}  
  

//echo $frequency.' '.$frequency;exit;
            
//Default
$life_type = 'Main Life'; 

// Calculate age
$dob   = new DateTime($date_of_birth);
$today = new DateTime();
$age   = $today->diff($dob)->y;

// Check waiting period rules
$sql = $con->prepare("
    SELECT waiting_period_months 
    FROM waiting_period_rules
    WHERE life_type = ?
      AND ? BETWEEN min_age AND max_age
    LIMIT 1
");

$sql->bind_param("si", $life_type, $age);
$sql->execute();
$sql->store_result();

// If no rule found → age not allowed
if ($sql->num_rows == 0) {
    $sql->close();
    $error_message = "Age $age is NOT allowed for $life_type $full_name_main";
    echo "<script>alert('$error_message'); window.history.back();</script>";
    exit;
}



        //$type = 'Telesales';
        // Get current date for update timestamp
        $update_date = date('Y-m-d H:i:s');

        // UPDATE existing record using $subscriber_id with prepared statement
        $stmt = $con->prepare("
            UPDATE subscription_main SET 
                mobile_money_number = ?,
                full_name = ?,
                date_of_birth = ?,
                gender = ?,
                policy_number = ?,
                product_name = ?,
                premium = ?,               
                onboarding_channel = ?,
                type = ?,                
                update_input_date = ?,
                update_userindex = ?,
                momo_network =?,
                total_premium =?
            WHERE subscriptions_id = ?
        ");

        if ($stmt) {
            $stmt->bind_param(
                "ssssssdsssisss",
                $mobile_money_number,
                $full_name_main,
                $date_of_birth,
                $gender,
                $policy_number,
                $product_name,
                $premiums,                
                $onboarding_channel,
                $type,
                $update_date,
                $userindex,
                $telco_network,
                $total_premiumcc,
                $subscriber_id
            );

            if ($stmt->execute()) {
                //$success_message = "Main Life  Endorse successfully! " . $full_name_main;

                
// ===============================
// Prepare UPDATE statement
// ===============================
$stmt = $con->prepare("
    UPDATE subscription_mandate_sub
    SET
        frequency = ?,
        mobile_money_number = ?,
        momo_network = ?,
        total_premium = ?
    WHERE subscriptions_id = ?
");
if (!$stmt) {
    die("Prepare failed: " . $con->error);
}
// ===============================
// Bind parameters
// ===============================
// s = string, d = double
$stmt->bind_param(
    "sssdi",
    $frequency,
    $mobile_money_number,
    $telco_network,
    $total_premiumcc,
    $subscriber_id
);
// ===============================
// Execute
// ===============================
if (!$stmt->execute()) {
    die("Update failed: " . $stmt->error);
}
$stmt->close();


$data_inf = "Mobile: $mobile_money_number, "
         . "Name: $full_name_main, "
         . "DOB: $date_of_birth, "
         . "Policy Number: $policy_number, "
         . "Product: $product_name, "
         . "Premium: $total_premiumcc, "
         . "Payment Status: $payment_status, "
         . "Onboarding Channel: $onboarding_channel, "
         . "Endorsement_type Channel: $endorsement_type, "
         . "Type: $type";

                // Log the successful operation
                $page_path = 'policy_endorsement_main_addlifes.php';
                $reasons = 'Update Endorsement Main Successfully';
                log_failed_login($con, $userindex, $page_path, $reasons ,$data_inf);


                // current date for effective_date
$endorsement_date = date('Y-m-d');

// choose ONE of these two options:
$approved_by = null;
$endorsement_status = 'PENDING';

//if endorsement_type is not empty
if ($endorsement_type <> '') {
$result = insertPolicyEndorsement(
    $con,
    $policy_number,
    $endorsement_type,          // ✅ missing before – now added
    (string)$previous_value,
    (string)$new_value,
    $effective_date,
    $approved_by,
    $endorsement_status,
    (int)$userindex,
    $remarks                    // ✅ new field
);

if (!$result['status']) {
    die($result['message']);
}

}

//call function subscriber_id
try {
    syncSubscriptionToPolicyAndCustomer($con, $subscriber_id);
    //echo "Subscription sync successful.";
} catch (Exception $e) {
    echo "Error: " . $e->getMessage();
}


echo "
<script>
    alert('Main Life endorsed successfully! " . addslashes($full_name_main) . "');
    window.location.href = 'policy_endorsements_search.php';
</script>
";

            } else {
                $error_message = "Error updating record: " . $stmt->error;
            }
            $stmt->close();
        } else {
            $error_message = "Prepare failed: " . $con->error;
        }
    }
}







// Handle form submission for additional life (UPDATE)
if (isset($_POST['submit_additional'])) {
    $additional_id = isset($_POST['additional_id']) ? (int)$_POST['additional_id'] : 0;
    
    // Debug: Check all POST data
    if (isset($_POST['debug'])) {
        echo "<pre>DEBUG - POST Data:\n";
        print_r($_POST);
        echo "</pre>";
        exit;
    }
    
    if ($additional_id <= 0) {
        $error_message = "Error: Invalid additional life ID.";
    } else {
        // Sanitize inputs - use the NULL coalescing operator to avoid undefined index errors
        $mobile_money_number_addlife = trim($_POST['mobile_money_number_addlife'] ?? '');
        $full_name_addlife = trim($_POST['full_name_addlife'] ?? '');
        $date_of_birth_addlife = trim($_POST['date_of_birth_addlife'] ?? '');
        $gender_addlife = trim($_POST['gender_addlife'] ?? '');
        $relationship_addlife = trim($_POST['relationship_addlife'] ?? '');


       //Previous Data
        $mobile_money_number_addlifen = trim($_POST['mobile_money_number_addlifen'] ?? '');
        $full_name_addlifen = trim($_POST['full_name_addlifen'] ?? '');
        $date_of_birth_addlifen = trim($_POST['date_of_birth_addlifen'] ?? '');
        $gender_addlifen = trim($_POST['gender_addlifen'] ?? '');
        $relationship_addlifen = trim($_POST['relationship_addlifen'] ?? '');

        // $policy_number = trim($_POST['policy_number'] ?? '');

        //Default
$life_type = 'Secondary Life'; 

// Calculate age
$dob   = new DateTime($date_of_birth_addlife);
$today = new DateTime();
$age   = $today->diff($dob)->y;

// Check waiting period rules
$sql = $con->prepare("
    SELECT waiting_period_months 
    FROM waiting_period_rules
    WHERE life_type = ?
      AND ? BETWEEN min_age AND max_age
    LIMIT 1
");

$sql->bind_param("si", $life_type, $age);
$sql->execute();
$sql->store_result();

// If no rule found → age not allowed
if ($sql->num_rows == 0) {
    $sql->close();
    $error_message = "Age $age is NOT allowed for $life_type $full_name_main";
    echo "<script>alert('$error_message'); window.history.back();</script>";
    exit;
}

       

        $data_inf = "ID: $additional_id, "
         . "Mobile: $mobile_money_number_addlife, "
         . "Name: $full_name_addlife, "
         . "DOB: $date_of_birth_addlife, "
         . "Gender: $gender_addlife, "
         . "Relationship: $relationship_addlife";


 $previous_value = 
    "Mobile: {$mobile_money_number_addlifen}, " .
    "Name: {$full_name_addlifen}, " .
    "DOB: {$date_of_birth_addlifen}, " .
    "Gender: {$gender_addlifen}, " .
    "Relationship: {$relationship_addlifen}";


    $new_value = 
    "Mobile: {$mobile_money_number_addlife}, " .
    "Name: {$full_name_addlife}, " .
    "DOB: {$date_of_birth_addlife}, " .
    "Gender: {$gender_addlife}, " .
    "Relationship: {$relationship_addlife}";

        // Update timestamp
        $current_date = date('Y-m-d H:i:s');
        $effective_date = date('Y-m-d');
         $input_date =  date('Y-m-d H:i:s');
         $endose_date = date('Y-m-d');

        // Prepared UPDATE statement
        $stmt = $con->prepare("
            UPDATE subscription_additionallife SET 
                mobile_money_number = ?, 
                full_name = ?, 
                date_of_birth = ?, 
                gender = ?, 
                relationship = ?, 
                date = ?
            WHERE subscriptions_id_addtional = ?
        ");

        if ($stmt) {
            $stmt->bind_param(
                "ssssssi",
                $mobile_money_number_addlife,
                $full_name_addlife,
                $date_of_birth_addlife,
                $gender_addlife,
                $relationship_addlife,
                $current_date,
                $additional_id
            );

            if ($stmt->execute()) {
                
// ===============================
// Prepare INSERT statement subscription_addlife_endorsements
// ===============================
$stmt = $con->prepare("
    INSERT INTO subscription_addlife_endorsements
    (
        policy_number,
        previous_value,
        new_value,
        effective_date,
        userindex,
        input_date
    )
    VALUES (?, ?, ?, ?, ?, ?)
");
if (!$stmt) {
    die("Prepare failed: " . $con->error);
}
// ===============================
// Bind parameters
// ===============================
// s = string, i = integer
$stmt->bind_param(
    "ssssis",
    $policy_number,
    $previous_value,
    $new_value,
    $effective_date,
    $userindex,
    $input_date
);
if (!$stmt->execute()) {
    die("Insert failed: " . $stmt->error);
}
// Optional: get inserted ID
$endorsement_id = $stmt->insert_id;
$stmt->close(); 
                            


// Update secondary_lives
mysqli_query(
    $con,
    "UPDATE secondary_lives
     SET
        full_name = '$full_name_addlife',
        relationship = '$relationship_addlife',
        date_of_birth = '$date_of_birth_addlife',
        mobile_money_number = '$mobile_money_number_addlife',
        gender = '$gender_addlife',
        endose_date = '$endose_date',
        subscriptions_id_addtional = '$additional_id'
     WHERE mobile_money_number = '$mobile_money_number_addlifen'
       AND subscriptions_id = '$subscriber_id'"
) or die(mysqli_error($con));

               
               
//$_SESSION['success_message'] = "Additional life updated successfully! " . $full_name_addlife;
                

                  // Log the successful operation
                $page_path = 'policy_endorsements_main_addlifes.php';
                $reasons = 'Update Additional life Successfully';
                log_failed_login($con, $userindex, $page_path, $reasons ,$data_inf);
                
                // Refresh the data
            // header("Location: " . $_SERVER['PHP_SELF'] . "?id=" . urlencode(encrypt($subscriber_id)));
 
      echo "
<script>
    alert('Additional life updated successfully! " . addslashes($full_name_addlife) . "');
    window.location.href = 'policy_endorsements_search.php';
</script>
"; 
                
            } else {
                //$error_message = "Execute failed: " . $stmt->error;
                  $_SESSION['error_message'] = "Execute failed: " . $stmt->error;
            }
            $stmt->close();
        } else {
            //$error_message = "Prepare failed: " . $con->error;
             $_SESSION['error_message'] = "Prepare failed: " . $con->error;
        }
    }
}




// Handle REMOVE additional life
if (isset($_POST['remove_additional'])) {
    $additional_id = isset($_POST['additional_id']) ? (int)$_POST['additional_id'] : 0;

//search before you detele
$query = "SELECT * FROM subscription_additionallife WHERE subscriptions_id_addtional = ?";
$stmt = $con->prepare($query);

if (!$stmt) {
    die("Prepare failed: " . $con->error);
}

$stmt->bind_param("i", $additional_id);
$stmt->execute();
$result_search = $stmt->get_result();

if ($result_search->num_rows > 0) {
    $test_search = $result_search->fetch_assoc();

    // Correct column names
    $mobile_money_number_addlife = trim($test_search['mobile_money_number']);
    $full_name_addlife          = trim($test_search['full_name']);
    $date_of_birth_addlife      = trim($test_search['date_of_birth']);
    $gender_addlife             = trim($test_search['gender']);
    $relationship_addlife       = trim($test_search['relationship']);

} else {
    die("Error: Additional life not found.");
}

    
    if ($additional_id <= 0) {
        $error_message = "Error: Invalid additional life ID.";
    } else {


  
        
    //remove addtional life
    $stmt = $con->prepare("DELETE FROM subscription_additionallife WHERE subscriptions_id_addtional = ?");
        
        if ($stmt) {
            $stmt->bind_param("i", $additional_id);
            
            if ($stmt->execute()) {


                //$success_message = "Additional life removed successfully!";
  // Store success in session before redirect


  $data_inf = "Mobile: $mobile_money_number_addlife, "
         . "Name: $full_name_addlife, "
         . "DOB: $date_of_birth_addlife, "
         . "Gender: $gender_addlife, "
         . "Relationship: $relationship_addlife";

         $new_value = 
    "Mobile: {$mobile_money_number_addlife}, " .
    "Name: {$full_name_addlife}, " .
    "DOB: {$date_of_birth_addlife}, " .
    "Gender: {$gender_addlife}, " .
    "Relationship: {$relationship_addlife}";

     // Update timestamp
        $current_date = date('Y-m-d H:i:s');
        $effective_date = date('Y-m-d');
         $input_date =  date('Y-m-d H:i:s');

//SELECT PREMIUM
$result_selectpremium = mysqli_query($con,
    "SELECT premium,policy_number FROM subscription_main
 WHERE subscriptions_id = '$subscriber_id'"
);
if (!$result_selectpremium) {
    die("Error: Data not found..");
}
$test_selectpremium = mysqli_fetch_array($result_selectpremium);
$premium_ans = trim($test_selectpremium['premium']);
$policy_number_ans = trim($test_selectpremium['policy_number']);

//get total premium function
$data = getPremiumForAdditionalLives($con, $subscriber_id, $premium_ans);
$count         = $data['count'];
$premium_mains = $data['premium_main'];
$premium_one   = $data['premium_one'];
$premium_two   = $data['premium_two'];
if ($count == 0) {
    $total_premiumcc = $premium_mains;
} 

elseif ($count == 1) {
    $total_premiumcc = $premium_one;
} 
elseif ($count == 2) {
    $total_premiumcc = $premium_two;  
}

//update subscription_main
//========================
mysqli_query($con,"update subscription_main
 set premium = '$premium_ans',
 total_premium = '$total_premiumcc',
 update_userindex = '$userindex',
 update_input_date = '$input_date'
where subscriptions_id = '$subscriber_id' ") or die (mysqli_error($con));


//Update subscription_mandate_sub
//==============================
mysqli_query($con,"update subscription_mandate_sub
 set total_premium = '$total_premiumcc',
 update_userindex = '$userindex',
 update_date = '$input_date'
where subscriptions_id = '$subscriber_id' ") or die (mysqli_error($con));

$previous_value ='record deleted from database';
// ===============================
// Prepare INSERT statement subscription_addlife_endorsements
// ===============================
$stmt = $con->prepare("
    INSERT INTO subscription_addlife_endorsements
    (
        policy_number,
        previous_value,
        new_value,
        effective_date,
        userindex,
        input_date
    )
    VALUES (?, ?, ?, ?, ?, ?)
");
if (!$stmt) {
    die("Prepare failed: " . $con->error);
}
// s = string, i = integer
$stmt->bind_param(
    "ssssis",
    $policy_number,
    $previous_value,
    $new_value,
    $effective_date,
    $userindex,
    $input_date
);
if (!$stmt->execute()) {
    die("Insert failed: " . $stmt->error);
}
// Optional: get inserted ID
$endorsement_id = $stmt->insert_id;
$stmt->close(); 


//deletion from  secondary_lives
mysqli_query(
    $con,
    "DELETE FROM secondary_lives 
     WHERE subscriptions_id_addtional = '$additional_id'"
) or die(mysqli_error($con));

                //$_SESSION['success_message'] = "Subscription beneficiary removed successfully!";
                
                
                // Log the operation
                $page_path = 'policy_endorsements_main_addlifes.php';
                $reasons = 'Remove Additional life';
                log_failed_login($con, $userindex, $page_path, $reasons , $data_inf);

                
      echo "
<script>
    alert('Additional life Removed successfully! " . addslashes($full_name_addlife) . "');
    window.location.href = 'policy_endorsements_search.php';
</script>
"; 

                // Refresh the data
                //header("Location: " . $_SERVER['PHP_SELF'] . "?id=" . urlencode(encrypt($subscriber_id)));
                //exit();
            } else {
                //$error_message = "Execute failed: " . $stmt->error;
                   $_SESSION['error_message'] = "Execute failed: " . $stmt->error;
            }
            $stmt->close();
        }
    }
}



// Handle form submission for subscription beneficiary (UPDATE)
if (isset($_POST['submit_beneficiary'])) {
    $beneficiary_id = isset($_POST['beneficiary_id']) ? (int)$_POST['beneficiary_id'] : 0;
   
    
    if ($beneficiary_id <= 0) {
        $error_message = "Error: Invalid beneficiary ID.";
    } else {
        // Sanitize inputs
        $full_name_beneficiary = trim($_POST['full_name_beneficiary'] ?? '');
        $relationship_beneficiary = trim($_POST['relationship_beneficiary'] ?? '');
        $mobile_money_number_beneficiary = trim($_POST['mobile_money_number_beneficiary'] ?? '');


        $mobile_money_number_beneficiaryn = trim($_POST['mobile_money_number_beneficiaryn'] ?? '');

        //echo $mobile_money_number_beneficiaryn.' '.$mobile_money_number_beneficiary;exit;

        $new_value =
    "Name: {$full_name_beneficiary}, " .
    "Relationship: {$relationship_beneficiary}, " .
    "Mobile: {$mobile_money_number_beneficiary}";




        // Debug output
        //echo "Beneficiary ID: $beneficiary_id, Name: $full_name_beneficiary, Relationship: $relationship_beneficiary, Mobile: $mobile_money_number_beneficiary";
        //exit;
 $data_inf = "Beneficiary ID: $beneficiary_id, Name: $full_name_beneficiary, Relationship: $relationship_beneficiary, Mobile: $mobile_money_number_beneficiary";

        // Update timestamp
        $current_date = date('Y-m-d H:i:s');

        // Prepared UPDATE statement
        $stmt = $con->prepare("
            UPDATE subscription_beneficiaries SET 
                full_name = ?, 
                relationship = ?, 
                mobile_money_number = ?,
                created_at = ?
            WHERE subscription_beneficiary_id = ?
        ");

        if ($stmt) {
            $stmt->bind_param(
                "ssssi",
                $full_name_beneficiary,
                $relationship_beneficiary,
                $mobile_money_number_beneficiary,
                $current_date,
                $beneficiary_id
            );

            if ($stmt->execute()) {
                //$success_message = "Subscription beneficiary updated successfully!";

                  // Update timestamp
        $current_date = date('Y-m-d H:i:s');
        $effective_date = date('Y-m-d');
         $input_date =  date('Y-m-d H:i:s');


$previous_value = 'Beneficiary update';
 // ===============================
// Prepare INSERT statement subscription_addlife_endorsements
// ===============================
$stmt = $con->prepare("
    INSERT INTO subscription_addlife_endorsements
    (
        policy_number,
        previous_value,
        new_value,
        effective_date,
        userindex,
        input_date
    )
    VALUES (?, ?, ?, ?, ?, ?)
");
if (!$stmt) {
    die("Prepare failed: " . $con->error);
}
// s = string, i = integer
$stmt->bind_param(
    "ssssis",
    $policy_number,
    $previous_value,
    $new_value,
    $effective_date,
    $userindex,
    $input_date
);
if (!$stmt->execute()) {
    die("Insert failed: " . $stmt->error);
}
// Optional: get inserted ID
$endorsement_id = $stmt->insert_id;
$stmt->close();          
                
// Update customer (beneficiary-related fields)
mysqli_query(
    $con,
    "UPDATE beneficiaries
     SET
        full_name = '$full_name_beneficiary',
        mobile_money_number = '$mobile_money_number_beneficiary',
        subscription_beneficiary_id = '$beneficiary_id',
        relationship = '$relationship_beneficiary'
     WHERE mobile_money_number = '$mobile_money_number_beneficiaryn'
       AND subscriptions_id = '$subscriber_id'"
) or die(mysqli_error($con));




                
                //$_SESSION['success_message'] = "Subscription beneficiary updated successfully! " . $full_name_beneficiary;

                // Log the successful operation
                $page_path = 'policy_endorsements_main_addlifes.php';
                $reasons = 'Update Beneficiary Successfully';
                log_failed_login($con, $userindex, $page_path, $reasons , $data_inf);
                // Refresh the data
               // header("Location: " . $_SERVER['PHP_SELF'] . "?id=" . urlencode(encrypt($subscriber_id)));
               // exit();

     echo "
<script>
    alert('Beneficiary Updated successfully! " . addslashes($full_name_beneficiary) . "');
    window.location.href = 'policy_endorsements_search.php';
</script>
"; 

            } else {
                //$error_message = "Execute failed: " . $stmt->error;
                 $_SESSION['error_message'] = "Execute failed: " . $stmt->error;
            }
            $stmt->close();
        } else {
            //$error_message = "Prepare failed: " . $con->error;
             $_SESSION['error_message'] = "Prepare failed: " . $con->error;
        }
    }
}

// Handle REMOVE subscription beneficiary
if (isset($_POST['remove_beneficiary'])) {
    $beneficiary_id = isset($_POST['beneficiary_id']) ? (int)$_POST['beneficiary_id'] : 0;


 // Search before delete
$query = "SELECT * FROM subscription_beneficiaries WHERE subscription_beneficiary_id = ?";
$stmt = $con->prepare($query);

if (!$stmt) {
    die("Prepare failed: " . $con->error);
}

$stmt->bind_param("i", $beneficiary_id);
$stmt->execute();
$result_search = $stmt->get_result();

if ($result_search->num_rows > 0) {
    $test_search = $result_search->fetch_assoc();

    // Assign values
    $subscription_beneficiary_idn = trim($test_search['subscription_beneficiary_id']);
    $full_namen = trim($test_search['full_name']);
    $relationshipn = trim($test_search['relationship']);
    $mobile_money_numbern = trim($test_search['mobile_money_number']);

} else {
    die("Error: beneficiary_details not found.");
}

    
    if ($beneficiary_id <= 0) {
        $error_message = "Error: Invalid beneficiary ID.";
    } else {
        $stmt = $con->prepare("DELETE FROM subscription_beneficiaries WHERE subscription_beneficiary_id = ?");
        
        if ($stmt) {
            $stmt->bind_param("i", $beneficiary_id);
            
            if ($stmt->execute()) {
               // $success_message = "Subscription beneficiary removed successfully!";

                // Store success in session before redirect
                $_SESSION['success_message'] = "Subscription beneficiary removed successfully";


$data_inf = "ID: $subscription_beneficiary_idn, "
         . "Mobile: $mobile_money_numbern, "
         . "Name: $full_namen, "
         . "Relationship: $relationshipn";


         $previous_value =
    "Beneficiary ID: {$subscription_beneficiary_idn}, " .
    "Name: {$full_namen}, " .
    "Relationship: {$relationshipn}, " .
    "Mobile: {$mobile_money_numbern}";


    
  // Update timestamp
        $current_date = date('Y-m-d H:i:s');
        $effective_date = date('Y-m-d');
         $input_date =  date('Y-m-d H:i:s');

         $new_value ='This is a removal';
// ===============================
// Prepare INSERT statement subscription_addlife_endorsements
// ===============================
$stmt = $con->prepare("
    INSERT INTO subscription_addlife_endorsements
    (
        policy_number,
        previous_value,
        new_value,
        effective_date,
        userindex,
        input_date
    )
    VALUES (?, ?, ?, ?, ?, ?)
");
if (!$stmt) {
    die("Prepare failed: " . $con->error);
}
// s = string, i = integer
$stmt->bind_param(
    "ssssis",
    $policy_number,
    $previous_value,
    $new_value,
    $effective_date,
    $userindex,
    $input_date
);
if (!$stmt->execute()) {
    die("Insert failed: " . $stmt->error);
}
// Optional: get inserted ID
$endorsement_id = $stmt->insert_id;
$stmt->close(); 

    // Remove Beneficiary
// ================================
mysqli_query(
    $con,
    "DELETE FROM beneficiaries 
     WHERE subscription_beneficiary_id = '$beneficiary_id'"
) or die(mysqli_error($con));
            
                // Log the operation
                $page_path = 'policy_endorsement_main_addlifes.php';
                $reasons = 'Remove Subscription Beneficiary';
                log_failed_login($con, $userindex, $page_path, $reasons , $data_inf);
                // Refresh the data
               // header("Location: " . $_SERVER['PHP_SELF'] . "?id=" . urlencode(encrypt($subscriber_id)));
                //exit();

     echo "
<script>
    alert('Beneficiary Removal successfully! " . addslashes($full_name_beneficiary) . "');
    window.location.href = 'policy_endorsements_search.php';
</script>
"; 

            } else {
                $error_message = "Execute failed: " . $stmt->error;
            }
            $stmt->close();
        }
    }
}


// ================================
// ADD ADDITIONAL LIFE (INSERT)
// ================================
if (isset($_POST['add_additional_life'])) {

    // Required values
    $subscriptions_id    = isset($_POST['subscriptions_id']) ? (int)$_POST['subscriptions_id'] : 0;   
    $created_at          = date('Y-m-d H:i:s'); // column name in table is `date`
   // Sanitize inputs - use the NULL coalescing operator to avoid undefined index errors
        $mobile_money_number_addlife = trim($_POST['mobile_money_number_addlife'] ?? '');
        $full_name_addlife = trim($_POST['full_name_addlife'] ?? '');
        $date_of_birth_addlife = trim($_POST['date_of_birth_addlife'] ?? '');
        $gender_addlife = trim($_POST['gender_addlife'] ?? '');
        $relationship_addlife = trim($_POST['relationship_addlife'] ?? '');


 //Default
$life_type = 'Secondary Life'; 
// $life_type = $_POST['life_type'];

// Calculate age
$dob   = new DateTime($date_of_birth_addlife);
$today = new DateTime();
$age   = $today->diff($dob)->y;

// Check waiting period rules
$sql = $con->prepare("
    SELECT waiting_period_months 
    FROM waiting_period_rules
    WHERE life_type = ?
      AND ? BETWEEN min_age AND max_age
    LIMIT 1
");

$sql->bind_param("si", $life_type, $age);
$sql->execute();
$sql->store_result();

// If no rule found → age not allowed
if ($sql->num_rows == 0) {
    $sql->close();
    $error_message = "Age $age is NOT allowed for $life_type $full_name_main";
    echo "<script>alert('$error_message'); window.history.back();</script>";
    exit;
}

$new_value = 
    "Mobile: {$mobile_money_number_addlife}, " .
    "Name: {$full_name_addlife}, " .
    "DOB: {$date_of_birth_addlife}, " .
    "Gender: {$gender_addlife}, " .
    "Relationship: {$relationship_addlife}";

      
        
       $data_inf = "Mobile: $mobile_money_number_addlife, "
         . "Name: $full_name_addlife, "
         . "DOB: $date_of_birth_addlife, "
         . "Gender: $gender_addlife, "
         . "Relationship: $relationship_addlife, "
         . "subscriptions_id: $subscriptions_id";

        
      // Optional: clean mobile number (avoid spaces)
    //$mobile_money_number = preg_replace('/\s+/', '', $mobile_money_number);


  // Update timestamp
        $current_date = date('Y-m-d H:i:s');
        $effective_date = date('Y-m-d');
        $input_date =  date('Y-m-d H:i:s');

    // INSERT (Prepared Statement)
    $stmt = $con->prepare("
        INSERT INTO subscription_additionallife
            (subscriptions_id, mobile_money_number, full_name, date_of_birth, gender, relationship, `date`)
        VALUES
            (?, ?, ?, ?, ?, ?, ?)
    ");

    if (!$stmt) {
        $_SESSION['error_message'] = "Prepare failed: " . $con->error;
        header("Location: " . $_SERVER['PHP_SELF'] . "?id=" . urlencode(encrypt($subscriber_id)));
        exit;
    }

    $stmt->bind_param(
        "issssss",
        $subscriptions_id,
        $mobile_money_number_addlife,
        $full_name_addlife,
        $date_of_birth_addlife,
        $gender_addlife,
        $relationship_addlife,
        $created_at
    );

    if ($stmt->execute()) {
        $stmt->close();





        //$_SESSION['success_message'] = "Additional life added successfully: " . $full_name;

//SELECT PREMIUM
$result_selectpremium = mysqli_query($con,
    "SELECT premium,policy_number FROM subscription_main
 WHERE subscriptions_id = '$subscriber_id'"
);
if (!$result_selectpremium) {
    die("Error: Data not found..");
}
$test_selectpremium = mysqli_fetch_array($result_selectpremium);
$premium_ans = trim($test_selectpremium['premium']);
$policy_number_ans = trim($test_selectpremium['policy_number']);

//get total premium function
$data = getPremiumForAdditionalLives($con, $subscriber_id, $premium_ans);
$count         = $data['count'];
$premium_mains = $data['premium_main'];
$premium_one   = $data['premium_one'];
$premium_two   = $data['premium_two'];
if ($count == 0) {
    $total_premiumcc = $premium_mains;
} 

elseif ($count == 1) {
    $total_premiumcc = $premium_one;
} 
elseif ($count == 2) {
    $total_premiumcc = $premium_two;  
}

//update subscription_main
//========================
mysqli_query($con,"update subscription_main
 set premium = '$premium_ans',
 total_premium = '$total_premiumcc',
 update_userindex = '$userindex',
 update_input_date = '$input_date'
where subscriptions_id = '$subscriber_id' ") or die (mysqli_error($con));


//Update subscription_mandate_sub
//==============================
mysqli_query($con,"update subscription_mandate_sub
 set total_premium = '$total_premiumcc',
 update_userindex = '$userindex',
 update_date = '$input_date'
where subscriptions_id = '$subscriber_id' ") or die (mysqli_error($con));


$previous_value ='This is a new insertion';
// ===============================
// Prepare INSERT statement subscription_addlife_endorsements
// ===============================
$stmt = $con->prepare("
    INSERT INTO subscription_addlife_endorsements
    (
        policy_number,
        previous_value,
        new_value,
        effective_date,
        userindex,
        input_date
    )
    VALUES (?, ?, ?, ?, ?, ?)
");
if (!$stmt) {
    die("Prepare failed: " . $con->error);
}
// s = string, i = integer
$stmt->bind_param(
    "ssssis",
    $policy_number,
    $previous_value,
    $new_value,
    $effective_date,
    $userindex,
    $input_date
);
if (!$stmt->execute()) {
    die("Insert failed: " . $stmt->error);
}
// Optional: get inserted ID
$endorsement_id = $stmt->insert_id;
$stmt->close(); 


//echo $premium_ans.' '.$total_premiumcc.' '.$policy_number_ans.' '.$subscriber_id.' '.$premium_ans;exit;


//Select policyholder_id from policy_holders
$result_policyholder = mysqli_query(
    $con,
    "SELECT policyholder_id 
     FROM policy_holders 
     WHERE subscriptions_id = '$subscriber_id'"
);
if (!$result_policyholder) {
    die("Query failed: " . mysqli_error($con));
}
$test_policyholder = mysqli_fetch_array($result_policyholder);
if (!$test_policyholder) {
    die("Error: Data not found..");
}
$policyholder_idn = trim($test_policyholder['policyholder_id']);


$created_at = date('Y-m-d H:i:s');
// ===============================
// Prepare INSERT statement
// ===============================
$stmt = $con->prepare("
    INSERT INTO secondary_lives
    (
        policyholder_id,
        full_name,
        relationship,
        date_of_birth,
        created_at,
        userindex,
        mobile_money_number,
        gender,
        subscriptions_id
    )
    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)
");
if (!$stmt) {
    die("Prepare failed: " . $con->error);
}
// ===============================
// Bind parameters
// ===============================
// i = integer, s = string
$stmt->bind_param(
    "issssissi",
    $policyholder_idn,
    $full_name_addlife,
    $relationship_addlife,
    $date_of_birth_addlife,
    $created_at,
    $userindex,
    $mobile_money_number_addlife,
    $gender_addlife,
    $subscriber_id
);
// ===============================
// Execute
// ===============================
if (!$stmt->execute()) {
    die("Insert failed: " . $stmt->error);
}
$secondary_life_id = $stmt->insert_id; // optional
$stmt->close();

        
echo"
<script>
    alert('Additional life Added successfully! " . addslashes($full_name_addlife) . "');
    window.location.href = 'policy_endorsements_search.php';
</script>
";    
        
        
        
        // optional log
        //$data_inf = "SubscriptionID: $subscriptions_id, Mobile: $mobile_money_number, Name: $full_name, DOB: $date_of_birth, Gender: $gender, Relationship: $relationship";
        log_failed_login($con, $userindex, 'subscription_amendment.php', 'Add Subscription Additional Life', $data_inf);

        // Refresh page (keep your encrypted id)
        //header("Location: " . $_SERVER['PHP_SELF'] . "?id=" . urlencode(encrypt($subscriber_id)));
        //exit;

    } else {
        $_SESSION['error_message'] = "Execute failed: " . $stmt->error;
        $stmt->close();
        header("Location: " . $_SERVER['PHP_SELF'] . "?id=" . urlencode(encrypt($subscriber_id)));
        exit;
    }
}







// =====================================
// ADD BENEFICIARY (INSERT)
// =====================================
if (isset($_POST['add_beneficiary'])) {

    $subscriptions_id    = isset($_POST['subscriptions_id']) ? (int)$_POST['subscriptions_id'] : 0;
    $full_name           = trim($_POST['full_name'] ?? '');
    $relationship        = trim($_POST['relationship'] ?? '');
    $mobile_money_number = trim($_POST['mobile_money_number'] ?? '');
    $created_at          = date('Y-m-d H:i:s');

   

    // Optional: allow only digits and plus
    //$mobile_money_number = preg_replace('/[^0-9+]/', '', $mobile_money_number);


    // INSERT using prepared statement
    $stmt = $con->prepare("
        INSERT INTO subscription_beneficiaries
            (subscriptions_id, full_name, relationship, mobile_money_number, created_at)
        VALUES
            (?, ?, ?, ?, ?)
    ");

    if (!$stmt) {
        $_SESSION['error_message'] = "Prepare failed: " . $con->error;
        header("Location: " . $_SERVER['PHP_SELF'] . "?id=" . urlencode(encrypt($subscriber_id)));
        exit;
    }

    $stmt->bind_param(
        "issss",
        $subscriptions_id,
        $full_name,
        $relationship,
        $mobile_money_number,
        $created_at
    );

    if ($stmt->execute()) {
        $stmt->close();

        //$_SESSION['success_message'] = "Beneficiary added successfully: " . $full_name;

        // Optional logging
        $data_inf = "subscriptions_id: $subscriptions_id, Mobile: $mobile_money_number, Name: $full_name, Relationship: $relationship";
        log_failed_login($con, $userindex, 'policy_endorsements_main_addlifes.php', 'Add Beneficiary', $data_inf);


$new_value =
    "Name: {$full_name}, " .
    "Relationship: {$relationship}, " .
    "Mobile: {$mobile_money_number}";
    

  // Update timestamp
        $current_date = date('Y-m-d H:i:s');
        $effective_date = date('Y-m-d');
         $input_date =  date('Y-m-d H:i:s');
$previous_value ='This is a new insertion';
// ===============================
// Prepare INSERT statement subscription_addlife_endorsements
// ===============================
$stmt = $con->prepare("
    INSERT INTO subscription_addlife_endorsements
    (
        policy_number,
        previous_value,
        new_value,
        effective_date,
        userindex,
        input_date
    )
    VALUES (?, ?, ?, ?, ?, ?)
");
if (!$stmt) {
    die("Prepare failed: " . $con->error);
}
// s = string, i = integer
$stmt->bind_param(
    "ssssis",
    $policy_number,
    $previous_value,
    $new_value,
    $effective_date,
    $userindex,
    $input_date
);
if (!$stmt->execute()) {
    die("Insert failed: " . $stmt->error);
}
// Optional: get inserted ID
$endorsement_id = $stmt->insert_id;
$stmt->close(); 



//Select policyholder_id from policy_holders
$result_policyholder = mysqli_query(
    $con,
    "SELECT policyholder_id 
     FROM policy_holders 
     WHERE subscriptions_id = '$subscriber_id'"
);
if (!$result_policyholder) {
    die("Query failed: " . mysqli_error($con));
}
$test_policyholder = mysqli_fetch_array($result_policyholder);
if (!$test_policyholder) {
    die("Error: Data not found..");
}
$policyholder_idn = trim($test_policyholder['policyholder_id']);



// ===============================
// Prepare INSERT statement
// ===============================
$stmt = $con->prepare("
    INSERT INTO beneficiaries
    (
        policyholder_id,
        full_name,
        relationship,
        mobile_money_number,
        created_at,
        subscriptions_id
    )
    VALUES (?, ?, ?, ?, ?, ?)
");
if (!$stmt) {
    die("Prepare failed: " . $con->error);
}
// ===============================
// Bind parameters
// ===============================
// i=int, s=string
$stmt->bind_param(
    "issssi",
    $policyholder_idn,
    $full_name,
    $relationship,
    $mobile_money_number,
    $created_at,
    $subscriber_id
);
// ===============================
// Execute
// ===============================
if (!$stmt->execute()) {
    die("Insert failed: " . $stmt->error);
}
$beneficiary_id = $stmt->insert_id; // optional
$stmt->close();


        
echo"
<script>
    alert('Beneficiary Added successfully! " . addslashes($full_name_addlife) . "');
    window.location.href = 'policy_endorsements_search.php';
</script>
";    
        

        // Refresh page
        //header("Location: " . $_SERVER['PHP_SELF'] . "?id=" . urlencode(encrypt($subscriber_id)));
        //exit;

    } else {
        $_SESSION['error_message'] = "Execute failed: " . $stmt->error;
        $stmt->close();

        header("Location: " . $_SERVER['PHP_SELF'] . "?id=" . urlencode(encrypt($subscriber_id)));
        exit;
    }
}



?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Endorsement</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    
    <?php include 'main_menu_app.php'; ?>

    <style>
        body {
            background-image: url('images/ayo_banner4.png');
            background-size: cover;
            background-position: center;
            background-repeat: no-repeat;
            background-attachment: fixed;
            opacity: 0.9;
        }
        
        body::before {
            content: "";
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-image: url('images/ayo_banner4.png');
            background-size: cover;
            background-position: center;
            background-repeat: no-repeat;
            background-attachment: fixed;
            opacity: 0.5;
            z-index: -1;
        }
        
        .blue-text {
            color: blue;
        }
        
        .card {
            box-shadow: 0 0 20px rgba(0,0,0,0.1);
            border: none;
            border-radius: 10px;
            margin-bottom: 30px;
        }
        
        .nav-tabs {
            border-bottom: 2px solid #6ec1e4;
            background-color: #ffffff !important;
            position: relative;
            z-index: 10;
        }
        
        .nav-tabs .nav-link {
            color: #fff !important;
            background-color: #d5e3f5ff !important;
            font-weight: 500;
            border: none !important;
            padding: 12px 25px;
            margin-right: 6px;
            transition: all 0.3s;
        }
        
        .nav-tabs .nav-link:hover {
            color: #0a2cea !important;
            background-color: #e0f2ff !important;
        }
        
        .nav-tabs .nav-link.active {
            color: #fff !important;
            background-color: #aebbf9ff !important;
            border: none !important;
            border-bottom: 3px solid #0a2cea !important;
            font-weight: bold;
        }
        
        .form-label {
            font-weight: 600;
            color: #333;
            margin-bottom: 5px;
        }
        
        .form-control {
            border: 1px solid #ddd;
            border-radius: 5px;
            padding: 10px 15px;
            transition: all 0.3s;
        }
        
        .form-control:focus {
            border-color: #6ec1e4;
            box-shadow: 0 0 0 0.2rem rgba(110, 193, 228, 0.25);
        }
        
        .btn-primary {
            background: linear-gradient(135deg, #6ec1e4, #0a2cea);
            border: none;
            padding: 12px 30px;
            font-weight: 600;
            border-radius: 5px;
            transition: all 0.3s;
        }
        
        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(10, 44, 234, 0.3);
        }
        
        .btn-danger {
            background: linear-gradient(135deg, #dc3545, #a71d2a);
            border: none;
            padding: 8px 20px;
            font-weight: 600;
            border-radius: 5px;
            transition: all 0.3s;
        }
        
        .btn-danger:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(220, 53, 69, 0.3);
        }
        
        .alert {
            border-radius: 8px;
            border: none;
            padding: 15px 20px;
        }
        
        .tab-pane {
            padding: 25px;
            background: white;
            border-radius: 0 0 10px 10px;
        }
        
        .required:after {
            content: " *";
            color: #dc3545;
        }
        
        .record-table {
            width: 100%;
            margin-bottom: 20px;
        }
        
        .record-table th {
            background-color: #f8f9fa;
            font-weight: 600;
            color: #333;
            padding: 12px 15px;
            border-bottom: 2px solid #dee2e6;
        }
        
        .record-table td {
            padding: 10px 15px;
            vertical-align: middle;
            border-bottom: 1px solid #dee2e6;
        }
        
        .record-table tr:hover {
            background-color: #f8f9fa;
        }
        
        .action-buttons {
            display: flex;
            gap: 10px;
        }
        
        .no-records {
            text-align: center;
            padding: 30px;
            color: #6c757d;
            font-style: italic;
        }
    </style>
</head>
<body>
    <div class="content">
        <div class="container-fluid">
            <div class="row justify-content-center">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header card-header-primary" style="background: #6ec1e4; color: white; text-align: center; padding: 20px;">
                            <h4 class="card-title" style="color:#0a2cea; font-weight: bold; text-align: center;">
                                <i class="fas fa-user-plus"></i> Policy Endorsement
                            </h4>
                            <p class="card-category" style="color:white;">Manage Endorsement Of Addtional lifes , Beneficiaries & Premium Transactions</p>
                        </div>
                        
                        <div class="card-body">
                            <?php if ($success_message): ?>
                                <div class="alert alert-success alert-dismissible fade show" role="alert">
                                    <i class="fas fa-check-circle"></i> <?php echo $success_message; ?>
                                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                                </div>
                            <?php endif; ?>
                            
                            <?php if ($error_message): ?>
                                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                    <i class="fas fa-exclamation-circle"></i> <?php echo $error_message; ?>
                                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                                </div>
                            <?php endif; ?>
                            
                            <!-- Tabs Navigation -->
                            <ul class="nav nav-tabs" id="subscriptionTabs" role="tablist">
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link active" id="main-tab" data-bs-toggle="tab" data-bs-target="#main" type="button" role="tab">
                                        <i class="fas fa-user"></i> Main Subscription
                                    </button>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link" id="additional-tab" data-bs-toggle="tab" data-bs-target="#additional" type="button" role="tab">
                                        <i class="fas fa-users"></i> Additional Life
                                    </button>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link" id="beneficiary-tab" data-bs-toggle="tab" data-bs-target="#beneficiary" type="button" role="tab">
                                        <i class="fas fa-user-friends"></i> Subscription Beneficiary
                                    </button>
                                </li>
                            </ul>
                            
                            <!-- Tab Content -->
                            <div class="tab-content" id="subscriptionTabsContent">
                                
                                <!-- Main Subscription Tab -->
                                <div class="tab-pane fade show active" id="main" role="tabpanel">
                                    <form method="POST" action="">
                                        <div class="row">

                                                    <!-- Endorsement Type Dropdown -->
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label><strong></strong></label>
                                        <select class="form-control" name="endorsement_type" required>
                                            <option value="">-- Select Endorsement Type --</option>
                                            <option value="Frequency">Frequency</option>
                                            <option value="Mobile Wallet Number">Mobile Wallet Number</option>
                                            <option value="Telco">Telco</option>
                                            <option value="Premium">Premium</option>
                                            <option value="Main Life Name">Main Life Name</option>
                                            <option value="Main Life Dob">Main Life Dob</option>
                                            <option value="Addtional Life Name">Addtional Life Name</option>
                                            <option value="Additional Dob">Additional Dob</option>
                                            <option value="Additional Relationship">Additional Relationship</option>
                                            <option value="Beneficiary Name">Beneficiary Name</option>
                                            <option value="Beneficiary Dob">Beneficiary Dob</option>
                                            <option value="Beneficiary Relationship">Beneficiary Relationship</option>
                                        </select>
                                    </div>
                                </div>

                                <!-- Effective Date -->
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label><strong>Effective Date</strong></label>
                                        <input type="date"
                                               name="effective_date"
                                               class="form-control"
                                               required>
                                    </div>
                                </div>

                                 <div class="row mt-3">

                                <!-- Remarks -->
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label><strong>Remarks</strong></label>
                                        <textarea class="form-control"
                                                  name="remarks"
                                                  rows="3"
                                                  placeholder="Provide additional details if any"
                                                  required></textarea>
                                    </div>
                                </div>

                            </div>


                                            <div class="col-md-6">
                                                <div class="mb-3">
                                                    <label class="form-label required">Mobile Money Number</label>
                                                    <input type="text" 
                                                           class="form-control" 
                                                           name="mobile_money_number"
                                                           id="mobile_money_number"
                                                           pattern="^\+?[0-9]{10,15}$"
                                                           maxlength="16"
                                                           required
                                                           placeholder="e.g., 233244000000"
                                                           value="<?php echo htmlspecialchars($mobile_money_number); ?>"
                                                           oninput="this.value = this.value.replace(/[^0-9+]/g, '');">
                                                </div>
                                                
                                                <div class="mb-15">
                                                    <label class="form-label required">Full Name</label>
                                                    <input type="text" 
                                                           class="form-control" 
                                                           name="full_name_main"
                                                           required 
                                                           placeholder="Enter full name"
                                                           value="<?php echo htmlspecialchars($full_name_main); ?>">

  <input type="hidden" class="form-control"  name="frequencyn"  value="<?php echo $frequencyn; ?>">    
  <input type="hidden" class="form-control"  name="telco_networkn"  value="<?php echo $telco_networkn; ?>"> 

<input type="hidden" class="form-control"  name="total_premiumn"  value="<?php echo $total_premiumn; ?>"> 
  
  <input type="hidden" class="form-control"  name="total_premiumcc"  value="<?php echo $total_premiumcc; ?>"> 


  <input type="hidden" class="form-control"  name="premiumsn"  value="<?php echo $premiumsn; ?>">
    <input type="hidden" class="form-control"  name="date_of_birthn"  value="<?php echo $date_of_birthn; ?>">
  <input type="hidden" class="form-control"  name="full_name_mainn"  value="<?php echo $full_name_mainn; ?>">
                 <input type="hidden" class="form-control"  name="mobile_money_numbern"  value="<?php echo $mobile_money_numbern; ?>">

                                                </div>
                                                
                                                <div class="mb-3">
                                                    <label class="form-label required">Date of Birth</label>
                                                    <input type="date" 
                                                           class="form-control" 
                                                           name="date_of_birth"
                                                           required
                                                           max="<?php echo date('Y-m-d'); ?>"
                                                           value="<?php echo htmlspecialchars($date_of_birth); ?>">
                                                </div>
                                                
                                                <div class="mb-3">
                                                    <label class="form-label required">Gender</label>
                                                    <select class="form-control" name="gender" required>
                                                        <option value="<?php echo $gender ?>"><?php echo $gender ?></option>
                                                        <option value="Male" <?php echo ($gender === "Male") ? 'selected' : ''; ?>>Male</option>
                                                        <option value="Female" <?php echo ($gender === "Female") ? 'selected' : ''; ?>>Female</option>
                                                        <option value="Other" <?php echo ($gender === "Other") ? 'selected' : ''; ?>>Other</option>
                                                    </select>
                                                </div>
                                                
                                                <div class="mb-3">
                                                    <label class="form-label required">Ref Number</label>
                                                    <input type="text" 
                                                           class="form-control" 
                                                           name="policy_number"
                                                           required
                                                           placeholder="e.g., 12222222222"
                                                           value="<?php echo htmlspecialchars($policy_number); ?>" readonly>
                                                </div>
                                            </div>
                                            
                           <!-- Product Name Dropdown -->
        <div class="col-md-6">
            <div class="mb-3">
                <label class="form-label required">Product Name</label>
                <select class="form-control" id="product_name" name="product_name" required>
                    <option value="<?php echo $product_name; ?>"><?php echo $product_name !== '' ? $product_name : '-- Select Product --'; ?>
            </option>
                    <?php
                    // Fetch distinct product names from cover_levels_view
                    $sql = "SELECT DISTINCT product_name FROM cover_levels_view ORDER BY product_name ASC";
                    $result = $con->query($sql);
                    if ($result && $result->num_rows > 0) {
                        while ($row = $result->fetch_assoc()) {
                            $product_name_opt = htmlspecialchars($row['product_name']);
                            echo "<option value=\"{$product_name_opt}\">{$product_name_opt}</option>";
                        }
                    }
                    ?>
                </select>
            </div>
      
                           <!-- Premium Dropdown -->
        <div class="col-md-6">
            <div class="mb-3">
                <label class="form-label required">Premium (Main Life)</label>
                <select class="form-control" id="premiums" name="premiums" required>
                    <option value="<?php echo $premiums ?>"><?php echo $premiums ?></option>
                    <!-- Options will be loaded based on product selection -->
                </select>
            </div>
        </div>

         <div class="col-md-6">
            <div class="mb-3">
                <label class="form-label required">Total Premium</label>
                <select class="form-control" id="total_premium " name="total_premium " disabled>
                    <option value="<?php echo $total_premium ?>"><?php echo $total_premium  ?></option>              
                </select>
            </div>
        </div>

 <!-- Simple JS (no jQuery needed) -->
<script>
document.getElementById("product_name").addEventListener("change", function() {
    var selectedProduct = this.value;

    // If nothing selected, reset the premium dropdown
    var premiumSelect = document.getElementById("premiums");
    premiumSelect.innerHTML = "<option value=''>-- Select Premium --</option>";

    if (selectedProduct === "") {
        return;
    }

    var xhr = new XMLHttpRequest();
    xhr.open("POST", "load_premiums.php", true);
    xhr.setRequestHeader("Content-type", "application/x-www-form-urlencoded");

    xhr.onreadystatechange = function() {
        if (this.readyState === 4 && this.status === 200) {
            premiumSelect.innerHTML = this.responseText;
        }
    };

    xhr.send("product=" + encodeURIComponent(selectedProduct));
});
</script>
                                                 
                                                <div class="mb-3">
                                                    <label class="form-label required">Onboarding Channel</label>
                                                    <select class="form-control" name="onboarding_channel" required>
                                                        <option value="<?php echo $onboarding_channel ?>"><?php echo $onboarding_channel ?></option>
                                                        <option value="USSD">USSD</option>
                                                        <option value="Mobile App">Mobile App</option>
                                                        <option value="Web Portal">Web Portal</option>
                                                        <option value="Telesales Agent">Telesales Agent</option>
                                                    </select>
                                                </div>
                                                
                                                <div class="mb-3">
                                                    <label class="form-label">Type</label>
                                                    <input type="text" 
                                                           class="form-control" 
                                                           name="type"
                                                           readonly      
                                                           value="<?php echo htmlspecialchars($type); ?>">
                                                </div>
                                            </div>
                                        </div>


  <!-- Frequency -->
                <div class="mb-3">
                    <label class="form-label required">Frequency</label>
                    <select class="form-control" name="frequency" required> 
                        <option value="<?php echo $frequency ?>"><?php echo $frequency ?></option>
                        <option value="Monthly">Monthly</option>
                    </select>
                </div>
                
                <!-- Telco Network -->
              <div class="mb-3">
    <label class="form-label required">Telco Network</label>
    <div style="display:flex; align-items:center; gap:10px;">
        <img id="telco_icon" 
             src="images/default.png" 
             style="width:40px; height:40px; border-radius:6px; border:1px solid #ccc;">
        
        <select class="form-control"
                id="telco_select"
                name="telco_network"
                required>            
            <?php if (!empty($telco_network)) { ?>
                <option value="<?php echo htmlspecialchars($telco_network); ?>">
                    <?php echo htmlspecialchars($telco_network); ?>
                </option>
            <?php } else { ?>
                <option value="">Select Network</option>
            <?php } ?>

            <option value="MTN" data-icon="images/mtn.png">MTN</option>
            <option value="Telecel" data-icon="images/telecel.png">Telecel</option>
        </select>
    </div>
</div>
                    
                                        
                                        <div class="text-center mt-4">
                                            <button type="submit" name="submit_main" class="btn btn-primary">
                                                <i class="fas fa-save"></i> Update Main Life
                                            </button>
                                        </div>
                                    </form>
                                </div>
                                
                                <!-- Additional Life Tab -->                                             

                                <div class="tab-pane fade" id="additional" role="tabpanel">
                                    <!-- List of Additional Lifes -->
                                    <h5>Additional Life Records</h5>
                                    <?php if (count($additional_lifes) > 0): ?>
                                        <table class="record-table">
                                            <thead>
                                                <tr>
                                                    <th>Full Name</th>
                                                    <th>Mobile Number</th>
                                                    <th>Date of Birth</th>
                                                    <th>Gender</th>
                                                    <th>Relationship</th>
                                                    <th>Actions</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php foreach ($additional_lifes as $additional): ?>
                                                <tr>
                                                    <td><?php echo $additional['full_name']; ?></td>
                                                    <td><?php echo $additional['mobile_money_number']; ?></td>
                                                    <td><?php echo $additional['date_of_birth']; ?></td>
                                                    <td><?php echo $additional['gender']; ?></td>
                                                    <td><?php echo $additional['relationship']; ?></td>
                                                    <td class="action-buttons">
                                                        <button type="button" class="btn btn-sm btn-primary" 
                                                                onclick="editAdditionalLife(<?php echo $additional['subscriptions_id_addtional']; ?>)"
                                                                data-bs-toggle="modal" 
                                                                data-bs-target="#editAdditionalModal">
                                                            <i class="fas fa-edit"></i> Edit
                                                        </button>
                                                        <form method="POST" style="display: inline;">
                                                            <input type="hidden" name="additional_id" value="<?php echo $additional['subscriptions_id_addtional']; ?>">
                                                            <button type="submit" name="remove_additional" class="btn btn-sm btn-danger" 
                                                                    onclick="return confirm('Are you sure you want to remove this additional life?')">
                                                                <i class="fas fa-trash"></i> Remove
                                                            </button>
                                                        </form>
                                                    </td>
                                                </tr>
                                                <?php endforeach; ?>
                                            </tbody>
                                        </table>
                                    <?php else: ?>
                                        <div class="no-records">
                                            <p>No additional life records found for this subscription.</p>
                                        </div>
                                    <?php endif; ?>
                                    <div class="text-end">
                                        <div class="text-center">
  <button type="button"
          class="btn btn-primary btn-sm mt-2"
          data-bs-toggle="modal"
          data-bs-target="#addAdditionalModal">
    <i class="fas fa-plus"></i> Add Additional Life
  </button>
</div>

</div>
                                </div>


                                
                                <!-- Subscription Beneficiary Tab -->
                                <div class="tab-pane fade" id="beneficiary" role="tabpanel">
                                    <!-- List of Subscription Beneficiaries -->
                                    <h5>Subscription Beneficiary Records</h5>
                                    <?php if (count($subscription_beneficiaries) > 0): ?>
                                        <table class="record-table">
                                            <thead>
                                                <tr>
                                                    <th>Full Name</th>
                                                    <th>Relationship</th>
                                                    <th>Mobile Money Number</th>
                                                    <th>Created At</th>
                                                    <th>Actions</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php foreach ($subscription_beneficiaries as $beneficiary): ?>
                                                <tr>
                                                    <td><?php echo $beneficiary['full_name']; ?></td>
                                                    <td><?php echo $beneficiary['relationship']; ?></td>
                                                    <td><?php echo $beneficiary['mobile_money_number']; ?></td>
                                                    <td><?php echo $beneficiary['created_at']; ?></td>
                                                    <td class="action-buttons">
                                                        <button type="button" class="btn btn-sm btn-primary" 
                                                                onclick="editBeneficiary(<?php echo $beneficiary['subscription_beneficiary_id']; ?>)"
                                                                data-bs-toggle="modal" 
                                                                data-bs-target="#editBeneficiaryModal">
                                                            <i class="fas fa-edit"></i> Edit
                                                        </button>
                                                        <form method="POST" style="display: inline;">
                                                            <input type="hidden" name="beneficiary_id" value="<?php echo $beneficiary['subscription_beneficiary_id']; ?>">
                                                            <button type="submit" name="remove_beneficiary" class="btn btn-sm btn-danger" 
                                                                    onclick="return confirm('Are you sure you want to remove this beneficiary?')">
                                                                <i class="fas fa-trash"></i> Remove
                                                            </button>
                                                        </form>
                                                    </td>
                                                </tr>
                                                <?php endforeach; ?>
                                            </tbody>
                                        </table>
                                    <?php else: ?>
<div class="no-records">
  <p>No subscription beneficiary records found for this subscription.</p>

  <button type="button"
          class="btn btn-primary btn-sm mt-2"
          data-bs-toggle="modal"
          data-bs-target="#addBeneficiaryModal">
    <i class="fas fa-plus"></i> Add Beneficiary
  </button>
</div>
                                    <?php endif; ?>
                                </div>
                                

                        
                        <div class="card-footer" style="background: #f8f9fa; padding: 15px;">
                            <div class="row">
                                <div class="col-md-6">
                                    <small class="text-muted">
                                        <i class="fas fa-info-circle"></i> Fields marked with * are required
                                    </small>
                                </div>
                                <div class="col-md-6 text-end">
                                    <small class="text-muted">
                                        <i class="fas fa-database"></i> System Time: <?php echo date('n/j/Y H:i:s'); ?>
                                    </small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script>
document.addEventListener('DOMContentLoaded', function() {
    const telcoSelect = document.getElementById('telco_select');
    const telcoIcon = document.getElementById('telco_icon');
    
    if (telcoSelect && telcoIcon) {
        // Update icon when selection changes
        telcoSelect.addEventListener('change', function() {
            const selectedOption = this.options[this.selectedIndex];
            const iconPath = selectedOption.getAttribute('data-icon') || 'images/default.png';
            telcoIcon.src = iconPath;
        });
        
        // Initialize icon on page load if a value is already selected
        if (telcoSelect.value) {
            const selectedOption = telcoSelect.options[telcoSelect.selectedIndex];
            const iconPath = selectedOption.getAttribute('data-icon') || 'images/default.png';
            telcoIcon.src = iconPath;
        }
    }
});
</script>
    
    <!-- Edit Additional Life Modal -->
    <div class="modal fade" id="editAdditionalModal" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Edit Additional Life</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <form method="POST" action="">
                    <div class="modal-body">
                        <input type="hidden" id="additional_id" name="additional_id" value="">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label required">Mobile Money Number</label>
                                    <input type="text" 
                                           class="form-control" 
                                           id="mobile_money_number_addlife"
                                           name="mobile_money_number_addlife"
                                           required
                                           placeholder="e.g., 233244000000">
                                </div>
                                
                                <div class="mb-3">
                                    <label class="form-label required">Full Name</label>
                                    <input type="text" 
                                           class="form-control" 
                                           id="full_name_addlife"
                                           name="full_name_addlife"
                                           required 
                                           placeholder="Enter full name">
                                </div>
                                
<div class="mb-3">
    <label class="form-label required">Date of Birth</label>
    <input type="date" 
           class="form-control" 
           id="date_of_birth_addlife"
           name="date_of_birth_addlife"
           required
           max="<?php echo date('Y-m-d'); ?>"
           value="<?php echo htmlspecialchars($date_of_birth_addlife); ?>">

<input type="hidden" class="form-control" id="mobile_money_number_addlifen" name="mobile_money_number_addlifen" value="<?php echo $mobile_money_number_addlifen; ?>">
<input type="hidden" class="form-control" id="full_name_addlifen" name="full_name_addlifen" value="<?php echo $full_name_addlifen; ?>">
<input type="hidden" class="form-control" id="date_of_birth_addlifen" name="date_of_birth_addlifen" value="<?php echo $date_of_birth_addlifen; ?>">
<input type="hidden" class="form-control" id="gender_addlifen" name="gender_addlifen" value="<?php echo $gender_addlifen; ?>">
<input type="hidden" class="form-control" id="relationship_addlifen" name="relationship_addlifen" value="<?php echo $relationship_addlifen; ?>">

</div>


                            </div>
                            
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label required">Gender</label>
                                    <select class="form-control" id="gender_addlife" name="gender_addlife" required>
                                        <option value="">Select Gender</option>
                                        <option value="Male">Male</option>
                                        <option value="Female">Female</option>
                                        <option value="Other">Other</option>
                                    </select>
                                </div>
                                
                                <div class="mb-3">
                                    <label class="form-label required">Relationship</label>
                                    <select class="form-control" id="relationship_addlife" name="relationship_addlife" required>
                                        <option value="">Select Relationship</option>
                                        <option value="Mother">Mother</option>
                                        <option value="Father">Father</option>
                                        <option value="Father-in-law">Father-in-law</option>
                                        <option value="Mother-in-law">Mother-in-law</option>
    
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" name="submit_additional" class="btn btn-primary">Update</button>
                    </div>
                </form>
            </div>
        </div>
    </div>



<!-- ============================================= -->
    <!-- ADDITIONAL LIVES MODALS -->
    <!-- ============================================= -->
    
    <!-- Add Additional Life Modal -->
    <div class="modal fade" id="addAdditionalModal" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header modal-header-custom">
                    <h5 class="modal-title"><i class="fas fa-user-plus"></i> Add Additional Life</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <form method="POST" action="">
                    <input type="hidden" name="subscriptions_id" value="<?php echo $subscriber_id; ?>">
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-6">
                                 <div class="mb-3">
                                    <label class="form-label required">Full Name</label>
                                    <input type="text" 
                                           class="form-control" 
                                           id="full_name_addlife"
                                           name="full_name_addlife"
                                           required 
                                           placeholder="Enter full name">
                                </div>
                                
   <div class="mb-3">
  <label class="form-label required">Mobile Money Number</label>
  <input type="text"
         class="form-control"
         id="mobile_money_number_addlife"
         name="mobile_money_number_addlife"
         required
         placeholder="e.g., 0244000000 or 233244000000"
         pattern="^(\+233|233|0)[0-9]{9}$"
         maxlength="13"
         title="Enter a valid Ghana mobile number (e.g. 0244000000 or 233244000000)"
         oninput="this.value=this.value.replace(/[^0-9+]/g,'');">
</div>

                                
                             <div class="mb-3">
    <label class="form-label required">Date of Birth</label>
    <input type="date" 
           class="form-control" 
           id="date_of_birth_addlife"
           name="date_of_birth_addlife"
           required
           max="<?php echo date('Y-m-d'); ?>"
           value="<?php echo htmlspecialchars($date_of_birth_addlife); ?>">
</div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label required"><i class="fas fa-venus-mars"></i> Gender</label>
                                    <select class="form-control" name="gender_addlife" required>
                                        <option value="">Select Gender</option>
                                        <option value="Male">Male</option>
                                        <option value="Female">Female</option>
                                        <option value="Other">Other</option>
                                    </select>
                                </div>
                                
                                <div class="mb-3">
                                    <label class="form-label required"><i class="fas fa-heart"></i> Relationship</label>
                                    <select class="form-control" name="relationship_addlife" required>
                                      <option value="">Select Relationship</option>
                                        <option value="Mother">Mother</option>
                                        <option value="Father">Father</option>
                                        <option value="Father-in-law">Father-in-law</option>
                                        <option value="Mother-in-law">Mother-in-law</option>
                                    </select>
                                </div>
                                                               
                            </div>
                        </div>
                    </div>
             <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" name="add_additional_life" class="btn btn-primary">
                        <i class="fas fa-plus-circle"></i> Add Additional Life
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>


<!-- ============================================= -->
    <!-- BENEFICIARIES MODALS -->
    <!-- ============================================= -->
    
    <!-- Add Beneficiary Modal -->
    <div class="modal fade" id="addBeneficiaryModal" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header modal-header-custom">
                    <h5 class="modal-title"><i class="fas fa-user-plus"></i> Add Beneficiary</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <form method="POST" action="">
                    <input type="hidden" name="subscriptions_id" value="<?php echo $subscriber_id; ?>">
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label required"><i class="fas fa-user"></i> Full Name</label>
                                    <input type="text" class="form-control" name="full_name" required maxlength="100">
                                </div>
                                
                                <div class="mb-3">
                                    <label class="form-label required"><i class="fas fa-heart"></i> Relationship</label>
                                    <select class="form-control" name="relationship" required>
                                        <option value="">Select Relationship</option>
                                        <option value="Spouse">Spouse</option>
                                        <option value="Child">Child</option>
                                        <option value="Parent">Parent</option>
                                        <option value="Sibling">Sibling</option>
                                        <option value="Brother">Brother</option>  
                                        <option value="Friend">Friend</option>   
                                    </select>
                                </div>
                            </div>
                            
                            <div class="col-md-6">

                                   <div class="mb-3">
  <label class="form-label required">Mobile Money Number</label>
  <input type="text"
         class="form-control"
         id="mobile_money_number"
         name="mobile_money_number"
         required
         placeholder="e.g., 0244000000 or 233244000000"
         pattern="^(\+233|233|0)[0-9]{9}$"
         maxlength="13"
         title="Enter a valid Ghana mobile number (e.g. 0244000000 or 233244000000)"
         oninput="this.value=this.value.replace(/[^0-9+]/g,'');">
</div>
                                                               
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" name="add_beneficiary" class="btn btn-primary">
                            <i class="fas fa-plus-circle"></i> Add Beneficiary
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
   
    
    <!-- Edit Beneficiary Modal -->
    <div class="modal fade" id="editBeneficiaryModal" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Edit Subscription Beneficiary</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <form method="POST" action="">
                    <div class="modal-body">
                        <input type="hidden" id="beneficiary_id" name="beneficiary_id" value="">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label required">Full Name</label>
                                    <input type="text" 
                                           class="form-control" 
                                           id="full_name_beneficiary"
                                           name="full_name_beneficiary"
                                           required
                                           placeholder="Enter full name">
                                </div>
                                
                                <div class="mb-3">
                                    <label class="form-label required">Relationship</label>
                                    <select class="form-control" id="relationship_beneficiary" name="relationship_beneficiary" required>
                                        <option value="">Select Relationship</option>
                                        <option value="Brother">Brother</option>
                                        <option value="Sister">Sister</option>
                                        <option value="Father">Father</option>
                                        <option value="Mother">Mother</option>
                                        <option value="Spouse">Spouse</option>
                                        <option value="Child">Child</option>
                                        <option value="Friend">Friend</option>                                       
                                    </select>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label required">Mobile Money Number</label>
                                    <input type="text" 
                                           class="form-control" 
                                           id="mobile_money_number_beneficiary"
                                           name="mobile_money_number_beneficiary"
                                           required
                                           placeholder="e.g., 233244000000">

 <input type="hidden" class="form-control" id="mobile_money_number_beneficiaryn" name="mobile_money_number_beneficiaryn"  value=<?php echo $mobile_money_number_beneficiaryn; ?>>

                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" name="submit_beneficiary" class="btn btn-primary">Update</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <!-- Bootstrap JS Bundle with Popper -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Store all additional life data in a JavaScript object
        const additionalLifeData = {
            <?php foreach ($additional_lifes as $additional): ?>
            <?php echo $additional['subscriptions_id_addtional']; ?>: {
                mobile_money_number: '<?php echo addslashes($additional['mobile_money_number']); ?>',
                full_name: '<?php echo addslashes($additional['full_name']); ?>',
                date_of_birth: '<?php echo $additional['date_of_birth']; ?>',
                gender: '<?php echo $additional['gender']; ?>',
                relationship: '<?php echo $additional['relationship']; ?>'
            },
            <?php endforeach; ?>
        };
        
        // Store all beneficiary data in a JavaScript object
        const beneficiaryData = {
            <?php foreach ($subscription_beneficiaries as $beneficiary): ?>
            <?php echo $beneficiary['subscription_beneficiary_id']; ?>: {
                full_name: '<?php echo addslashes($beneficiary['full_name']); ?>',
                relationship: '<?php echo $beneficiary['relationship']; ?>',
                mobile_money_number: '<?php echo addslashes($beneficiary['mobile_money_number']); ?>'
            },
            <?php endforeach; ?>
        };
        
        // Function to edit Additional Life
function editAdditionalLife(id) {
  console.log('Editing Additional Life ID:', id);
  console.log('Available Data:', additionalLifeData);

  const data = additionalLifeData[id];
  if (!data) {
    console.error('No data found for ID:', id);
    alert('Error: Could not load data for this record.');
    return;
  }

  console.log('Found Data:', data);

  // Helper to set input value safely
  const setVal = (elId, val) => {
    const el = document.getElementById(elId);
    if (el) el.value = val ?? '';
  };

  // Helper to set select value safely
  const setSelect = (elId, val) => {
    const el = document.getElementById(elId);
    if (!el) return;
    el.value = val ?? '';
  };

  // Populate modal form (Current)
  setVal('additional_id', id);
  setVal('mobile_money_number_addlife', data.mobile_money_number);
  setVal('full_name_addlife', data.full_name);
  setVal('date_of_birth_addlife', data.date_of_birth);

  // Populate modal form (Previous)
  setVal('mobile_money_number_addlifen', data.mobile_money_number);
  setVal('full_name_addlifen', data.full_name);
  setVal('date_of_birth_addlifen', data.date_of_birth);

  // Set select values (Previous)
  setSelect('gender_addlifen', data.gender);
  setSelect('relationship_addlifen', data.relationship);

  // Set select values (Current)
  setSelect('gender_addlife', data.gender);
  setSelect('relationship_addlife', data.relationship);

  console.log('Form populated with:', {
    id,
    mobile: data.mobile_money_number,
    name: data.full_name,
    dob: data.date_of_birth,
    gender: data.gender,
    relationship: data.relationship
  });
}

        
        // Function to edit Beneficiary
        function editBeneficiary(id) {
            console.log('Editing Beneficiary ID:', id);
            console.log('Available Data:', beneficiaryData);
            
            const data = beneficiaryData[id];
            if (data) {
                console.log('Found Data:', data);
                
                // Populate the modal form
                document.getElementById('beneficiary_id').value = id;
                document.getElementById('full_name_beneficiary').value = data.full_name;
                document.getElementById('mobile_money_number_beneficiary').value = data.mobile_money_number;
                document.getElementById('mobile_money_number_beneficiaryn').value = data.mobile_money_number;
                
                
                // Set select value
                const relationshipSelect = document.getElementById('relationship_beneficiary');
                if (relationshipSelect) {
                    for (let i = 0; i < relationshipSelect.options.length; i++) {
                        if (relationshipSelect.options[i].value === data.relationship) {
                            relationshipSelect.selectedIndex = i;
                            break;
                        }
                    }
                }
                
                // Show debug info
                console.log('Form populated with:', {
                    id: id,
                    name: data.full_name,
                    relationship: data.relationship,
                    mobile: data.mobile_money_number
                });
            } else {
                console.error('No data found for ID:', id);
                alert('Error: Could not load data for this record.');
            }
        }
        
        // Form validation and enhancement
        document.addEventListener('DOMContentLoaded', function() {
            // Auto-format mobile money number
            const mobileInputs = document.querySelectorAll('input[name^="mobile_money_number"]');
            mobileInputs.forEach(input => {
                input.addEventListener('blur', function() {
                    let value = this.value.replace(/\D/g, '');
                    if (value.length >= 10) {
                        this.value = value;
                    }
                });
            });
            
            // Debug function to check what's in the data objects
            console.log('Additional Life Data on load:', additionalLifeData);
            console.log('Beneficiary Data on load:', beneficiaryData);
            
            // Add a debug button to check form data before submission
            const additionalForm = document.querySelector('#editAdditionalModal form');
            if (additionalForm) {
                additionalForm.addEventListener('submit', function(e) {
                    console.log('Additional Life Form submitted with data:', {
                        additional_id: document.getElementById('additional_id').value,
                        mobile_money_number_addlife: document.getElementById('mobile_money_number_addlife').value,
                        full_name_addlife: document.getElementById('full_name_addlife').value,
                        date_of_birth_addlife: document.getElementById('date_of_birth_addlife').value,
                        gender_addlife: document.getElementById('gender_addlife').value,
                        relationship_addlife: document.getElementById('relationship_addlife').value
                    });
                });
            }
            
            const beneficiaryForm = document.querySelector('#editBeneficiaryModal form');
            if (beneficiaryForm) {
                beneficiaryForm.addEventListener('submit', function(e) {
                    console.log('Beneficiary Form submitted with data:', {
                        beneficiary_id: document.getElementById('beneficiary_id').value,
                        full_name_beneficiary: document.getElementById('full_name_beneficiary').value,
                        relationship_beneficiary: document.getElementById('relationship_beneficiary').value,
                        mobile_money_number_beneficiary: document.getElementById('mobile_money_number_beneficiary').value
                    });
                });
            }
            
            // Initialize tooltips
            var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
            var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
                return new bootstrap.Tooltip(tooltipTriggerEl);
            });
        });
    </script>
</body>
</html>
<?php
mysqli_close($con);
?>