<?php  

include("database.php");
require_once('crypto_functions.php');
include("session.php");

$msg 			= 	htmlspecialchars(filter_var(mysqli_real_escape_string($con,$_REQUEST['msg']),FILTER_SANITIZE_STRING));
$name 			= 	htmlspecialchars(filter_var(mysqli_real_escape_string($con,$_REQUEST['name']),FILTER_SANITIZE_STRING));
$userindex 			= 	htmlspecialchars(filter_var(mysqli_real_escape_string($con,$_SESSION['userindex']),FILTER_SANITIZE_STRING));
$idn 			= 	htmlspecialchars(filter_var(mysqli_real_escape_string($con,$_REQUEST['id']),FILTER_SANITIZE_STRING));



// Encrypt the data
$idn = decrypt($idn);
$id = urlencode($idn);

//echo $id;exit;

// Fetch user data securely
$stmt = $con->prepare("SELECT *   FROM product WHERE product_index = ?");
$stmt->bind_param("s", $id);
$stmt->execute();
$result_search = $stmt->get_result();

if ($result_search->num_rows === 0) {
    die("Error: Data not found.");
}

$test_search = $result_search->fetch_assoc();
$product_name = htmlspecialchars($test_search['product_name']);
$product_description = htmlspecialchars($test_search['product_description']);
$product_num_code = htmlspecialchars($test_search['product_num_code']);
$product_num_date = htmlspecialchars($test_search['product_num_date']);
$product_num_gen = htmlspecialchars($test_search['product_num_gen']);


$stmt->close();


// Use parameterized queries for database interactions
function fetchData($con, $query) {
    $stmt = $con->prepare($query);
    $stmt->execute();
    return $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
}

$capturing_date = date("d-m-Y");
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <link rel="icon" type="image/png" href="../assets/img/favicon.png">
  <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />
  <title>Edit New Product Page</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
  <link href="../assets/css/material-dashboard.css?v=2.1.1" rel="stylesheet" />
  <link href="../assets/demo/demo.css" rel="stylesheet" />
</head>
<body>
<?php include 'main_menu.php'; ?>

<style>
body {
    background-image: url('images/ayo_banner4.png'); /* Replace with your actual image path */
    background-size: cover;
    background-position: center;
    background-repeat: no-repeat;
    background-attachment: fixed;
    opacity: 0.9;
}
body::before {
    content: "";
    position: fixed;
    top: 0; left: 0;
    width: 100%; height: 100%;
    background-image: url('images/ayo_banner4.png');
    background-size: cover;
    background-position: center;
    background-repeat: no-repeat;
    background-attachment: fixed;
    opacity: 0.5;
    z-index: -1;
}
</style>

</style>
<script type="text/javascript">
window.onload = function(){ 
               
   if (form.msg.value == "") {
    return false ;
  }
      if(form.msg.value == "10$909?c") {
    alert("Submitted Successfully");
    form.msg.focus();
    return false ;
  } 
  

}
</script>

<div class="content">
    <div class="container-fluid">
        <div class="row">
            <!-- Add Product Form -->
            <div class="col-md-8">
                <div class="card">
                   <div class="card-header card-header-primary" 
                        style="background: #6ec1e4; color: white; text-align: center; padding: 15px;">
                         <h4 class="card-title" style="color:rgb(10, 44, 234); font-weight: bold; text-align: center;">
                            Edit New Product
                         </h4>
                        <p class="card-category">Please Complete This Form</p>
                    </div>
                    <div class="card-body">
                        <form id="form" name="form" method="post" action="product_edit_eng.php" 
                              onsubmit="return validateForm(this)">
                            <div class="row">                               
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="bmd-label-floating">Product Name</label>
                                        <input type="text" class="form-control" name="product_name" value ="<?php echo htmlspecialchars($product_name); ?>" required>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="bmd-label-floating">Product Description</label>
                                        <input type="text" class="form-control" name="product_description" value ="<?php echo htmlspecialchars($product_description); ?>" required>
                                        <input type="hidden" name="userindex" value ="<?php echo htmlspecialchars($userindex); ?>">
                                         <input type="hidden" name="id" value ="<?php echo htmlspecialchars($id); ?>">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="bmd-label-floating">Four Digit Code</label>
                                        <input type="text" class="form-control" name="product_num_code" value ="<?php echo htmlspecialchars($product_num_code); ?>" required>
                                    </div>
                                </div>
                                                            <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="bmd-label-floating">Date (Y-m-d)</label>
                                        <input type="text" class="form-control" name="product_num_date" value ="<?php echo htmlspecialchars($product_num_date); ?>" required>
                                    </div>
                                </div>
                                                            <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="bmd-label-floating">Num Generated</label>
                                        <input type="text" class="form-control" name="product_num_gen" value ="<?php echo htmlspecialchars($product_num_gen); ?>" required>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="bmd-label-floating">Registration Date</label>
                                        <input type="text" class="form-control" readonly 
                                               name="capturing_date" 
                                               value="<?php echo htmlspecialchars($capturing_date); ?>">
                                    </div>
                                </div>
                            </div>
                            <button type="submit" class="btn btn-primary pull-right"  
                                    style="background: #6ec1e4; color: white; text-align: center; padding: 10px;">
                                Update
                            </button>
                            <div class="clearfix"></div>
                        </form>
                    </div>
                </div>
            </div>

            <!-- Sidebar Profile / Summary -->
            <div class="col-md-4">
                <div class="card card-profile">
                    <div class="card-avatar">
                        <a href="#">
                            <img class="img" src="images/product.jpg" />
                        </a>
                    </div>
                    <div class="card-body">
                        <h6 class="card-category text-gray">Admin Name: <?php echo htmlspecialchars($name); ?></h6>
                        <h4 class="card-title">Summary</h4>
                        <p class="card-description">
                        <?php
                        $stmt = $con->prepare("SELECT COUNT(product_index) AS count_active FROM product");
                        $stmt->execute();
                        $stmt->bind_result($count_active);
                        $stmt->fetch();
                        echo 'Total Products: ' . htmlspecialchars($count_active);
                        $stmt->close();
                        ?>
                        </p>
                        <a href="product_report.php?sr=018!b110" class="btn btn-primary btn-round" 
                           style="background: #6ec1e4; color: white; text-align: center; padding: 10px;">
                           View Report
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
</body>
</html>
