<?php

// Connect to Database
include("database.php");
include("session.php");


// Fetch and sanitize input
$search_id = isset($_REQUEST['hold']) ? trim($_REQUEST['hold']) : '';
$searchallitems = isset($_REQUEST['searchallitems']) ? trim($_REQUEST['searchallitems']) : '';

// Validate and escape input to prevent SQL injection and XSS
$search_id = mysqli_real_escape_string($con, filter_var($search_id, FILTER_SANITIZE_STRING));
$searchallitems = mysqli_real_escape_string($con, filter_var($searchallitems, FILTER_SANITIZE_STRING));


// Encrypt ID securely
$encrypted_string = htmlspecialchars($searchallitems, ENT_QUOTES, 'UTF-8');

//echo $search_id.' '.$encrypted_string;exit;




// product_rules_report.php
if ($search_id == '018!b113') {
    $url = "product_rules_report.php?sr=018!b113&urc={$encrypted_string}";
    header("Location: $url");
    exit;
}


// parameters_report.php
if ($search_id == '018!b112') {
    $url = "parameters_report.php?sr=018!b112&urc={$encrypted_string}";
    header("Location: $url");
    exit;
}



// map_agency_report.php
if ($search_id == '018!b111') {
    $url = "map_agency_report.php?sr=018!b111&urc={$encrypted_string}";
    header("Location: $url");
    exit;
}



// product_report.php
if ($search_id == '018!b110') {
    $url = "product_report.php?sr=018!b110&urc={$encrypted_string}";
    header("Location: $url");
    exit;
}



// user_report.php.php
if ($search_id == '716!b108') {
    $url = "user_report.php?sr=716!b108&urc={$encrypted_string}";
    header("Location: $url");
    exit;
}



// org_report.php
if ($search_id == '716!b100') {
    $url = "org_report.php?sr=716!b100&urc={$encrypted_string}";
    header("Location: $url");
    exit;
}


//branch_report.php
if ($search_id == '716!b101') {
    $url = "branch_report.php?sr=716!b101&urc={$encrypted_string}";
    header("Location: $url");
    exit;
}



// Handle default dashboard condition
if (empty($search_id)) {
        $url = " dashboard.php?id=";
    header("Location: $url");
    exit;   
    // Placeholder for dashboard redirection or additional logic
}
?>
