<?php
// Connect to Database
include("database.php");
include("session.php");

// Get user index safely (numeric)
$userindex = isset($_SESSION['userindex']) ? (int)$_SESSION['userindex'] : 0;

// Read msg safely
$msg = isset($_REQUEST['msg']) ? trim($_REQUEST['msg']) : '';
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <link rel="icon" type="image/png" href="../assets/img/favicon.png">
  <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />
  <title>Customer Registration</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />

  <link href="../assets/css/material-dashboard.css?v=2.1.1" rel="stylesheet" />
  <link href="../assets/demo/demo.css" rel="stylesheet" />
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/css/bootstrap.min.css">
  <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/js/bootstrap.bundle.min.js"></script>

  <style>
    body {
      background-image: url('images/ayo_banner4.png');
      background-size: cover;
      background-position: center;
      background-repeat: no-repeat;
      background-attachment: fixed;
    }

    body::before {
      content: "";
      position: fixed;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      background-image: url('images/ayo_banner4.png');
      background-size: cover;
      background-position: center;
      background-repeat: no-repeat;
      background-attachment: fixed;
      opacity: 0.5;
      z-index: -1;
    }
  </style>
</head>

<body>
<?php include 'main_menu.php'; ?>

<script>
document.addEventListener('DOMContentLoaded', function () {
  const msg = <?= json_encode($msg); ?>;

  if (msg === "10cc009kc") {
    alert("Terms & Conditions sent successfully.");
  }
});

function validateForm() {
  return confirm("Are you sure you want to proceed?");
}
</script>

<div class="content">
  <div class="container-fluid">
    <div class="row">
      <div class="col-md-10 mx-auto">
        <div class="card">
          <div class="card-header card-header-primary" style="background:#6ec1e4; color:#fff; text-align:center; padding:15px;">
            <h4 class="card-title mb-0">Policy Terms & Conditions</h4>
          </div>

          <div class="card-body">
            <form id="form" name="form" method="post" action="terms_conditions_eng.php" onsubmit="return validateForm();" enctype="multipart/form-data">

              <div class="mb-3">
  <label class="form-label">Customer Mobile Number</label>
  <input
    type="text"
    class="form-control"
    name="mobile_no"
    placeholder="e.g., 233244229547"
    pattern="^(0\d{9}|233\d{9})$"
    title="Enter a valid Ghana mobile number (0244229547 or 233244229547)"
    required
  >
</div>


              <div class="mb-3">
                <label class="form-label">Status Code</label>
                <input type="hidden" class="form-control" name="msg" value="<?= htmlspecialchars($msg, ENT_QUOTES, 'UTF-8'); ?>" readonly>
              </div>

              <button type="submit" class="btn btn-primary" style="background:#6ec1e4; border:none; padding:12px 24px;">
                Send
              </button>

            </form>
          </div>

        </div>
      </div>
    </div>
  </div>
</div>

</body>
</html>
