<?php 
//Connect to Database
include("database.php");
//require_once('crypto_functions.php');


$msg 			= 	htmlspecialchars(filter_var(mysqli_real_escape_string($con,$_REQUEST['msg']),FILTER_SANITIZE_STRING));

// Safely handle the encrypted string
$encrypted_string = $_REQUEST['urc'] ?? '';
$decrypted_string = '';

if (!empty($encrypted_string)) {
    // Assuming decryption is required; replace with proper decryption logic
    $decrypted_string = $encrypted_string; // Example: Replace with actual decryption logic
}

// Sanitize user input using prepared statements
$searchallitems = htmlspecialchars($decrypted_string, ENT_QUOTES, 'UTF-8');

// Prepare the query securely
if (!empty($searchallitems)) {
    // Use a prepared statement to prevent SQL injection
    $Query = "SELECT userindex,sub_priv_name, branch_name, user_name, user_status, 
                     user_reg_date, user_mobile, last_activity,user_surname,user_othernames
              FROM users_view
              WHERE user_name LIKE ? 
              OR user_mobile LIKE ? 
              OR branch_name LIKE ? 
              OR sub_priv_name LIKE ? 
              OR user_team_name LIKE ? 
              ORDER BY userindex DESC";
    $stmt = $con->prepare($Query);
    $search_param = '%' . $searchallitems . '%';
    $stmt->bind_param("sssss", $search_param, $search_param, $search_param, $search_param, $search_param);
} else {
    $Query = "SELECT userindex,sub_priv_name, branch_name, user_name, user_status, 
                     user_reg_date, user_mobile, last_activity,user_surname,user_othernames
              FROM users_view
              ORDER BY userindex DESC";
    $stmt = $con->prepare($Query);
}
$stmt->execute();
$result = $stmt->get_result();

?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8" />
  <link rel="apple-touch-icon" sizes="76x76" href="../assets/img/apple-icon.png">
  <link rel="icon" type="image/png" href="../assets/img/favicon.png">
  <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />
  <title>
VIEW USER MANAGEMENT
  </title>
  <meta content='width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0, shrink-to-fit=no' name='viewport' />
  <!--     Fonts and icons     -->
  <!-- CSS Files -->
  <link href="../assets/css/material-dashboard.css?v=2.1.1" rel="stylesheet" />
  <!-- CSS Just for demo purpose, don't include it in your project -->
  <link href="../assets/demo/demo.css" rel="stylesheet" />
</head>

<?php include 'main_menu.php' ?>
<style>
        body {
    background-image: url('images/ayo_banner4.png'); /* Replace with your actual image path */
    background-size: cover;
  background-position: center;
    background-repeat: no-repeat;
    background-attachment: fixed;
    opacity: 0.9; /* Adjust transparency (0.1 to 1) */
}

body::before {
    content: "";
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-image: url('images/ayo_banner4.png');
    background-size: cover;
    background-position: center;
    background-repeat: no-repeat;
    background-attachment: fixed;
    opacity: 0.5; /* Adjust transparency */
    z-index: -1;
}

</style>

<script type="text/javascript">
window.onload = function(){ 
               
   if (form.msg.value == "") {
    return false ;
  }
      if(form.msg.value == "10$229?c") {
    alert("Updated Successfully");
    form.msg.focus();
    return false ;
  } 
  

  if(form.msg.value == "10$230?c") {
    alert("Deleted Successfully");
    form.msg.focus();
    return false ;
  } 


  if(form.msg.value == "10$235?c") {
    alert("Password Reset Successfully");
    form.msg.focus();
    return false ;
  } 
  

  if(form.msg.value == "10$239?c") {
    alert("User Not Found");
    form.msg.focus();
    return false ;
  } 
  
    
}
</script>


<form id="form" name="form" method="POST" action="" enctype="multipart/form-data">
<input type="hidden" name="msg" value="<?php echo htmlspecialchars($msg); ?>">
</form>

      <div class="content">
        <div class="container-fluid">
          <div class="row">
            <div class="col-md-12">
              <div class="card">
                <div class="card-header card-header-primary" style="background: #6ec1e4; color: white; text-align: center; padding: 15px;>
                  <h4 class="card-title ">View User Managament</h4>
				   <p class="card-category"><a href="user_report.php?sr=716!b108"id="export_button" class="btn btn-primary btn-lick"/>Click Here To Extract To Excel</a></p>
                </div>
                <div class="card-body">
                  <div class="table-responsive">
                    <table class="table" id="report_data">
                      <thead class=" text-primary">
                         <th>
                         No.
                        </th>
                        <th>
                         Date.
                        </th>
                        <th>
                        Privilege
                        </th>	
                        <th>
                         User Name
                        </th>  	
                         <th>
                         Full Name
                        </th>	
                        <th>
                        Contact
                        </th>		
                        <th>
                        Status
                        </th>	
                        <th>
                        Branch
                        </th>		                                             
                        <th>
                          Controls
                        </th>
                        <th>
                        <a href="users_add.php" rel="tooltip" title="Add New" class="btn btn-primary btn-link btn-sm">
                                                <i class="material-icons">save</i>
                                            </a>
                        </th>
                      </thead>
                     <tbody>
                     
    <?php

$no = 0;
// Loop through the results
while ($test_user = $result->fetch_assoc()) {
    $user_reg_daten = htmlspecialchars($test_user['user_reg_date']);
    $impas_full_name = htmlspecialchars($test_user['user_surname'].' '.$test_user['user_othernames']);
    $sub_priv_name = htmlspecialchars($test_user['sub_priv_name']);
    $user_name = htmlspecialchars($test_user['user_name']);
    $user_mobile = htmlspecialchars($test_user['user_mobile']);
    $user_status = htmlspecialchars($test_user['user_status']);
    //$user_team_name = htmlspecialchars($test_user['user_team_name']);
    $branch_name = htmlspecialchars($test_user['branch_name']);
    $userid = htmlspecialchars($test_user['userindex']);
    
    
    // Format the date safely
    $user_reg_date = date("d-m-Y", strtotime($user_reg_daten));
    
    // Increment the counter
    $no++;

    // Encrypt the data
$userid = encrypt($userid);


    // Output the data securely
    echo '<tr>
              <td>' . $no . '</td>		
              <td>' . $user_reg_date . '</td>
              <td>' . $sub_priv_name . '</td>
               <td>' . $user_name . '</td>
               <td>' . $impas_full_name . '</td>              
               <td>' . $user_mobile . '</td>
              <td>' . $user_status . '</td>
              <td>' . $user_team_name . '</td>
              <td>' . $branch_name . '</td>
              <td class="td-actions text-center">						  
                  <a href="users_edit.php?id=' . urlencode($userid) . '" rel="tooltip" title="Edit Task" class="btn btn-primary btn-link btn-sm">
                      <i class="material-icons">edit</i>
                  </a>
                  <a href="users_delete_approval.php?id=' . urlencode($userid) . '" rel="tooltip" title="Remove" class="btn btn-danger btn-link btn-sm">
                      <i class="material-icons">close</i>
                  </a>	
                   <a href="users_password_reset.php?id=' . urlencode($userid) . '" rel="tooltip" title="Reset" class="btn btn-danger btn-link btn-sm">
                      <i class="material-icons">key</i>
                  </a>
              </td>
          </tr>';
}

?>                     
                          </td>                              
                        </tr>
                      </tbody>
                    </table>
                  </div>
                </div>
              </div>
            </div>
   <?php include 'footer.php' ?>
	  <script>
    function html_table_to_excel(type)
    {
        var data = document.getElementById('report_data');

        var file = XLSX.utils.table_to_book(data, {sheet: "sheet1"});

        XLSX.write(file, { bookType: type, bookSST: true, type: 'base64' });

        XLSX.writeFile(file, 'file.' + type);
    }

    const export_button = document.getElementById('export_button');

    export_button.addEventListener('click', () =>  {
        html_table_to_excel('xlsx');
    });

</script>
	  