
<?php 

//ini_set('display_errors', 1);


include("database.php");
require_once('crypto_functions.php');
include("session.php");

$msg 			= 	htmlspecialchars(filter_var(mysqli_real_escape_string($con,$_REQUEST['msg']),FILTER_SANITIZE_STRING));
$name 			= 	htmlspecialchars(filter_var(mysqli_real_escape_string($con,$_REQUEST['name']),FILTER_SANITIZE_STRING));
$userindex 			= 	htmlspecialchars(filter_var(mysqli_real_escape_string($con,$_SESSION['userindex']),FILTER_SANITIZE_STRING));
$idn 			= 	htmlspecialchars(filter_var(mysqli_real_escape_string($con,$_REQUEST['id']),FILTER_SANITIZE_STRING));



// Encrypt the data
$idn = decrypt($idn);
$user_id = urlencode($idn);



//echo $idn.' '.$user_id;exit;


// Fetch user data securely
$stmt = $con->prepare("SELECT * FROM users_view WHERE userindex = ?");
$stmt->bind_param("s", $user_id);
$stmt->execute();
$result_search = $stmt->get_result();

if ($result_search->num_rows === 0) {
    die("Error: Data not found.");
}

$test_search = $result_search->fetch_assoc();
//$user_idn = htmlspecialchars($test_search['userindex']);
$user_surname = htmlspecialchars($test_search['user_surname']);
$user_othernames = htmlspecialchars($test_search['user_othernames']);
$sub_priv_index = htmlspecialchars($test_search['sub_priv_index']);
$sub_priv_name = htmlspecialchars($test_search['sub_priv_name']);
$user_mobile = htmlspecialchars($test_search['user_mobile']);
$user_status = htmlspecialchars($test_search['user_status']);
$user_branchindex = htmlspecialchars($test_search['branchindex']);
$branch_name = htmlspecialchars($test_search['branch_name']);
$user_email = htmlspecialchars($test_search['user_email']);
$user_maxtime = htmlspecialchars($test_search['user_maxtime']);
$user_name = htmlspecialchars($test_search['user_name']);

$user_team_name = htmlspecialchars($test_search['user_team_name']);
$user_sub_priv_id = htmlspecialchars($test_search['user_sub_priv_id']);

$company_name = htmlspecialchars($test_search['company_name']);
$branch_name = htmlspecialchars($test_search['branch_name']);

$inactive_termination_date = htmlspecialchars($test_search['user_termination_date']);
$user_reg_date = htmlspecialchars($test_search['user_reg_date']);



if (!empty($user_reg_date)) {
    $user_reg_date = date("Y-m-d", strtotime($user_reg_date));
} else {
    $user_reg_date = '';
}


if (!empty($inactive_termination_date)) {
    $inactive_termination_date = date("Y-m-d", strtotime($inactive_termination_date));
} else {
    $inactive_termination_date = '';
}

//echo $inactive_termination_date.' '.$branch_name;exit;

$stmt->close();

//echo $sub_priv_index;exit;

//echo $branchindexn.' '.$branch_name;exit;

//echo $user_surname;exit;

//echo $user_branchindex;exit;
      

// Prepare the SQL query using placeholders to prevent SQL injection
$status = 'Active';
$statusn = 'InActive';
$statusns = 'Terminated';
$query = "SELECT count(user_status) FROM users WHERE user_status = ?";
$stmt = $con->prepare($query);
if (!$stmt) {
    die("Error preparing statement: " . $con->error);}
// Bind the parameter to the query
$stmt->bind_param('s', $status);
// Execute the query
if (!$stmt->execute()) {
    die("Error executing query: " . $stmt->error);}
// Fetch the result
$result_search = $stmt->get_result();
if ($result_search->num_rows === 0) {
    die("Error: No data found.");}
// Retrieve the data
$test_search = $result_search->fetch_assoc();
$user_count = $test_search['count(user_status)'];
// Close the statement
$stmt->close();


$query = "SELECT count(user_status) FROM users WHERE user_status = ?";
$stmt = $con->prepare($query);
if (!$stmt) {
    die("Error preparing statement: " . $con->error);}
// Bind the parameter to the query
$stmt->bind_param('s', $statusn);
// Execute the query
if (!$stmt->execute()) {
    die("Error executing query: " . $stmt->error);}
// Fetch the result
$result_search = $stmt->get_result();
if ($result_search->num_rows === 0) {
    die("Error: No data found.");}
// Retrieve the data
$test_search = $result_search->fetch_assoc();
$user_count1 = $test_search['count(user_status)'];
// Close the statement
$stmt->close();

$query = "SELECT count(user_status) FROM users WHERE user_status = ?";
$stmt = $con->prepare($query);
if (!$stmt) {
    die("Error preparing statement: " . $con->error);}
// Bind the parameter to the query
$stmt->bind_param('s', $statusns);
// Execute the query
if (!$stmt->execute()) {
    die("Error executing query: " . $stmt->error);}
// Fetch the result
$result_search = $stmt->get_result();
if ($result_search->num_rows === 0) {
    die("Error: No data found.");}
// Retrieve the data
$test_search = $result_search->fetch_assoc();
$user_count2 = $test_search['count(user_status)'];
// Close the statement
$stmt->close();


// Validate and sanitize user inputs (server-side)
function clean_input($data) {
    return htmlspecialchars(strip_tags(trim($data)));
}

// Use parameterized queries for database interactions
function fetchData($con, $query) {
    $stmt = $con->prepare($query);
    $stmt->execute();
    return $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
}


//echo $branchindexn;exit;

// Fetch data for dropdowns
$branches = fetchData($con, "SELECT branchindex, branch_name, company_name FROM branch_view ");
$privileges = fetchData($con, "SELECT sub_priv_index, sub_priv_name FROM sub_priv");
//$departments = fetchData($con, "SELECT departmentindex, department_name FROM department");


//Current Date
//$user_reg_date = date('d-m-Y');
?>
<style>
        body {
    background-image: url('images/ayo_banner4.png'); /* Replace with your actual image path */
    background-size: cover;
  background-position: center;
    background-repeat: no-repeat;
    background-attachment: fixed;
    opacity: 0.9; /* Adjust transparency (0.1 to 1) */
}

body::before {
    content: "";
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-image: url('images/ayo_banner4.png');
    background-size: cover;
    background-position: center;
    background-repeat: no-repeat;
    background-attachment: fixed;
    opacity: 0.5; /* Adjust transparency */
    z-index: -1;
}

</style>


<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <title>Edit User Page</title>
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, shrink-to-fit=no">
    <link href="../assets/css/material-dashboard.css?v=2.1.1" rel="stylesheet">
    <link href="../assets/demo/demo.css" rel="stylesheet">
</head>
<body>
    <?php include 'main_menu.php'; ?>
    <script type="text/javascript">
window.onload = function(){ 
               
   if (form.msg.value == "") {
    return false ;
  }
      if(form.msg.value == "10$29?c") {
    alert("Submitted Successfully");
    form.msg.focus();
    return false ;
  } 
  
}
</script>

<div class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-8">
                <div class="card">
                   <div class="card-header card-header-primary" style="background: #6ec1e4; color: white; text-align: center; padding: 15px;">
                         <h4 class="card-title" style="color:rgb(10, 44, 234); font-weight: bold; text-align: center;">Edit New User</h4>
                        <p class="card-category">Please Complete This Form</p>
                    </div>
                        <div class="card-body">
                            <form id="form" method="POST" action="users_edit_eng.php" enctype="multipart/form-data" onsubmit="return validateForm()">
                                <div class="form-group">
                                    <label>Surname</label>
                                    <input type="text" name="user_surname" class="form-control" value="<?php echo htmlspecialchars($user_surname ?? ''); ?>" required>

                                    <input type="hidden" name="user_id" class="form-control" value="<?php echo htmlspecialchars($user_id  ?? ''); ?>">


                                </div>
                                <div class="form-group">
                                    <label>Other Names</label>
                                    <input type="text" name="user_othernames" class="form-control" value="<?php echo htmlspecialchars($user_othernames ?? ''); ?>" required>
                                </div>
                               <div class="form-group">
                                    <label>Privilege</label>
                                    <select name="user_sub_priv" id = "user_sub_priv" class="form-control" required>
                                        <option value="<?php echo htmlspecialchars($sub_priv_index); ?>"><?php echo htmlspecialchars($sub_priv_name); ?></option>
                                        <?php foreach ($privileges as $privilege): ?>
                                            <option value="<?php echo htmlspecialchars($privilege['sub_priv_index']); ?>">
                                                
                                                <?php echo htmlspecialchars($privilege['sub_priv_name']); ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>


                                <div class="form-group">
                                    <label>Contact Number</label>
                                    <input type="text" name="user_mobile" class="form-control" pattern="\d+" value="<?php echo htmlspecialchars($user_mobile ?? ''); ?>" required>
                                </div>


                                <div class="form-group">
    <label>User Status</label>
    <select name="user_status" id="user_status" class="form-control" required>
        <option value="">Select</option>
        <option value="Active" <?php echo ($user_status ?? '') === 'Active' ? 'selected' : ''; ?>>Active</option>
        <option value="Inactive" <?php echo ($user_status ?? '') === 'Inactive' ? 'selected' : ''; ?>>Inactive</option>
        <option value="Terminated" <?php echo ($user_status ?? '') === 'Terminated' ? 'selected' : ''; ?>>Terminated</option>
    </select>
</div>



<div class="form-group">
    <label>Branch</label>
            <select name="user_branchindex" id="user_branchindex" class="form-control" required>
                    <option value="<?php echo htmlspecialchars($user_branchindex); ?>"><?php echo htmlspecialchars($company_name . " - " . $branch_name); ?></option>
                            <?php foreach ($branches as $branch): ?>
                            <option value="<?php echo htmlspecialchars($branch['branchindex']); ?>">
                    <?php echo htmlspecialchars($branch['company_name'] . " - " . $branch['branch_name']); ?>
                    </option>
            <?php endforeach; ?>
</select>
</div>
                       
 
 <div class="form-group"
    <label>Email Address</label>
    <input type="email" name="user_email" class="form-control" value="<?php echo htmlspecialchars($user_email ?? ''); ?>" required>
</div>
 
                  
                                <div class="form-group">
    <label>Registration Date</label>
  <input type="date" name="user_reg_date" class="form-control" 
       value="<?php echo !empty($user_reg_date) 
                        ? htmlspecialchars(date('Y-m-d', strtotime($user_reg_date))) 
                        : date('Y-m-d'); ?>">
    <input type="hidden" name="msg" value="<?php echo htmlspecialchars($msg); ?>">
    <input type="hidden" name="userindex" value="<?php echo htmlspecialchars($userindex); ?>">      
</div>

<div class="form-group" id="inactive_termination_group" style="display:none;">
    <label>Inactive / Termination Date</label>
    <input type="date" id="inactive_termination_date" name="inactive_termination_date" class="form-control" 
           value="<?php echo htmlspecialchars($inactive_termination_date ?? ''); ?>">     
</div>

<script>
document.getElementById("user_status").addEventListener("change", function() {
    let status = this.value;
    let dateGroup = document.getElementById("inactive_termination_group");
    let dateInput = document.getElementById("inactive_termination_date");

    if (status === "Inactive" || status === "Terminated") {
        dateGroup.style.display = "block";
        dateInput.setAttribute("required", "required");
    } else {
        dateGroup.style.display = "none";
        dateInput.removeAttribute("required");
        dateInput.value = ""; // optional: clear when hidden
    }
});

// Trigger on page load if editing an existing user
window.addEventListener("load", function() {
    document.getElementById("user_status").dispatchEvent(new Event("change"));
});
</script>

                   <div class="form-group">
                                    <label>Expiry Time</label>
                                    <select name="user_maxtime" class="form-control" required>
                                    <option value="<?php echo $user_maxtime ?>"><?php echo $user_maxtime.' '.'days' ?></option>
                                              <option value="60">60 days</option>
                                              <option value="90">90 days</option>
                                              <option value="365">365 days</option>
                                </select>
                                </div>

                                                             <div style="text-align: right;">
    <button type="submit" class="btn btn-primary" style="background: #6ec1e4; color: white; text-align: center; padding: 15px;">Update</button>
</div>
                            </form>
                        </div>
                    </div>
                </div>
              
                <!-- Summary Section -->
                <div class="col-md-4">
              <div class="card card-profile">
                <div class="card-avatar">
                  <a href="#pablo">
                    <img class="img" src="images/user_icon.png" />
                  </a>
                </div>
                <div class="card-body">
                  <h6 class="card-category text-gray">User Name : <?php echo $name; ?></h6>
                  <h4 class="card-title">Summary</h4>
                  <p class="card-description">
                            <p>Total Active Users: <?php echo htmlspecialchars($user_count); ?></p>
                            <p>Total Inactive Users: <?php echo htmlspecialchars($user_count1); ?></p>
                             <p>Total Terminated Users: <?php echo htmlspecialchars($user_count2); ?></p>
                            <a href="user_report.php?sr=016!b108" class="btn btn-primary btn-round" style="background: #6ec1e4; color: white; text-align: center; padding: 15px;">View Report</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>
