<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

//include('csrf_validator.php');
include('log_functions.php');
include("database.php");



function escape($string){
	return htmlspecialchars($string,ENT_QUOTES,'UTF-8');
}


$user_surname 			= 	htmlspecialchars(filter_var(mysqli_real_escape_string($con,$_POST['user_surname']),FILTER_SANITIZE_STRING));	
$user_othernames 		= 	htmlspecialchars(filter_var(mysqli_real_escape_string($con,$_POST['user_othernames']),FILTER_SANITIZE_STRING));	
$user_sub_priv 			= 	htmlspecialchars(filter_var(mysqli_real_escape_string($con,$_POST['user_sub_priv']),FILTER_SANITIZE_STRING));	
$user_mobile     = 	htmlspecialchars(filter_var(mysqli_real_escape_string($con,$_POST['user_mobile']),FILTER_SANITIZE_STRING));

$user_status     = 	htmlspecialchars(filter_var(mysqli_real_escape_string($con,$_POST['user_status']),FILTER_SANITIZE_STRING));	
$user_branchindex     = 	htmlspecialchars(filter_var(mysqli_real_escape_string($con,$_POST['user_branchindex']),FILTER_SANITIZE_STRING));	
$user_email     = 	htmlspecialchars(filter_var(mysqli_real_escape_string($con,$_POST['user_email']),FILTER_SANITIZE_STRING));		
$user_reg_daten     = 	htmlspecialchars(filter_var(mysqli_real_escape_string($con,$_POST['user_reg_date']),FILTER_SANITIZE_STRING));
$user_maxtime     = 	htmlspecialchars(filter_var(mysqli_real_escape_string($con,$_POST['user_maxtime']),FILTER_SANITIZE_STRING));

$userindex     = 	htmlspecialchars(filter_var(mysqli_real_escape_string($con,$_POST['userindex']),FILTER_SANITIZE_STRING));

//$user_sub_priv_id     = 	htmlspecialchars(filter_var(mysqli_real_escape_string($con,$_POST['user_sub_priv_id']),FILTER_SANITIZE_STRING));

$user_termination_date     = 	htmlspecialchars(filter_var(mysqli_real_escape_string($con,$_POST['inactive_termination_date']),FILTER_SANITIZE_STRING));

//$user_team_name     = 	htmlspecialchars(filter_var(mysqli_real_escape_string($con,$_POST['user_team_name']),FILTER_SANITIZE_STRING));

$user_id     = 	htmlspecialchars(filter_var(mysqli_real_escape_string($con,$_POST['user_id']),FILTER_SANITIZE_STRING));


//echo $user_id;exit;


// Date Format
$user_reg_date = date("Y-m-d", strtotime($user_reg_daten));
$inputdate = date("Y-m-d H:i:s");

// If user is active, usually there is no termination date
if ($user_status === 'Active') {
    $user_termination_date = null;
} else {
    // Format termination date properly (if provided)
    if (!empty($user_termination_date)) {
        $user_termination_date = date("Y-m-d H:i:s", strtotime($user_termination_date));
    } else {
        $user_termination_date = date("Y-m-d H:i:s"); // fallback: now
    }
}

//echo $user_termination_date;exit;


// Prepare the SQL statement
$sql = "
    UPDATE users 
    SET 
        user_sub_priv        = ?, 
        user_surname         = ?, 
        user_othernames      = ?, 
        user_branchindex     = ?, 
        user_email           = ?, 
        user_status          = ?, 
        user_mobile          = ?, 
        user_reg_date        = ?, 
        user_inputdate       = ?,
        user_maxtime         = ?,
        user_termination_date = ?
    WHERE userindex = ?
";

$stmt = $con->prepare($sql);

if (!$stmt) {
    // Log error for debugging
    error_log("Prepare failed in UPDATE users: " . $con->error);
    die("Error: Unable to prepare user update.");
}

// Bind the parameters to the prepared statement
// 11 strings (s) + 1 integer (i) = 12 placeholders total
if (!$stmt->bind_param(
    "sssssssssssi",
    $user_sub_priv,        // s
    $user_surname,         // s
    $user_othernames,      // s
    $user_branchindex,     // s (change to 'i' if column is INT and you cast)
    $user_email,           // s
    $user_status,          // s
    $user_mobile,          // s
    $user_reg_date,        // s (Y-m-d or Y-m-d H:i:s)
    $user_inputdate,       // s (Y-m-d H:i:s)
    $user_maxtime,         // s (or 'i' type if numeric)
    $user_termination_date,// s (can be NULL if active)
    $user_id               // i (userindex)
)) {
    error_log("bind_param failed in UPDATE users: " . $stmt->error);
    die("Error: Failed to bind parameters for user update.");
}

// Execute the statement
if (!$stmt->execute()) {
    error_log("Execute failed in UPDATE users: " . $stmt->error);
    die("Error: Unable to update user.");
}

// Close the statement
$stmt->close();


		    // Log the successful operation
			$page_path = 'user_edit.php';
			$reasons = 'updated Successfully';
            $data_inf = 'N/A';
			log_failed_login($con, $userindex, $page_path, $reasons ,$data_inf);


//Direct Page
header("location:user_report.php?sr=016!b108&msg=10$229?c");exit;

?>